/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.AbstractSimpleIdentifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.AnyXmlContextNode;
import org.opendaylight.yangtools.yang.data.util.AnydataContextNode;
import org.opendaylight.yangtools.yang.data.util.AugmentationContextNode;
import org.opendaylight.yangtools.yang.data.util.ChoiceNodeContextNode;
import org.opendaylight.yangtools.yang.data.util.ContainerContextNode;
import org.opendaylight.yangtools.yang.data.util.LeafContextNode;
import org.opendaylight.yangtools.yang.data.util.OrderedLeafListMixinContextNode;
import org.opendaylight.yangtools.yang.data.util.OrderedMapMixinContextNode;
import org.opendaylight.yangtools.yang.data.util.UnkeyedListMixinContextNode;
import org.opendaylight.yangtools.yang.data.util.UnorderedLeafListMixinContextNode;
import org.opendaylight.yangtools.yang.data.util.UnorderedMapMixinContextNode;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

public abstract class DataSchemaContextNode<T extends YangInstanceIdentifier.PathArgument>
extends AbstractSimpleIdentifiable<T> {
    private final DataSchemaNode dataSchemaNode;

    DataSchemaContextNode(T identifier, DataSchemaNode schema) {
        super(identifier);
        this.dataSchemaNode = schema;
    }

    @Deprecated(forRemoval=true, since="8.0.2")
    protected DataSchemaContextNode(T identifier, SchemaNode schema) {
        this(identifier, schema instanceof DataSchemaNode ? (DataSchemaNode)schema : null);
    }

    public boolean isMixin() {
        return false;
    }

    public boolean isKeyedEntry() {
        return false;
    }

    public abstract boolean isLeaf();

    protected Set<QName> getQNameIdentifiers() {
        return ImmutableSet.of((Object)((YangInstanceIdentifier.PathArgument)this.getIdentifier()).getNodeType());
    }

    public abstract @Nullable DataSchemaContextNode<?> getChild(YangInstanceIdentifier.PathArgument var1);

    public abstract @Nullable DataSchemaContextNode<?> getChild(QName var1);

    public final @Nullable DataSchemaContextNode<?> enterChild(SchemaInferenceStack stack, QName child) {
        return this.enterChild(Objects.requireNonNull(child), Objects.requireNonNull(stack));
    }

    protected abstract @Nullable DataSchemaContextNode<?> enterChild(@NonNull QName var1, @NonNull SchemaInferenceStack var2);

    public final @Nullable DataSchemaContextNode<?> enterChild(SchemaInferenceStack stack, YangInstanceIdentifier.PathArgument child) {
        return this.enterChild(Objects.requireNonNull(child), Objects.requireNonNull(stack));
    }

    protected abstract @Nullable DataSchemaContextNode<?> enterChild(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.PathArgument var1, @NonNull SchemaInferenceStack var2);

    protected void pushToStack(@NonNull SchemaInferenceStack stack) {
        stack.enterSchemaTree(((YangInstanceIdentifier.PathArgument)this.getIdentifier()).getNodeType());
    }

    public @Nullable DataSchemaNode getDataSchemaNode() {
        return this.dataSchemaNode;
    }

    public final @NonNull Optional<@NonNull DataSchemaContextNode<?>> findChild(@NonNull YangInstanceIdentifier path) {
        DataSchemaContextNode<?> currentOp = this;
        for (YangInstanceIdentifier.PathArgument arg : path.getPathArguments()) {
            if ((currentOp = currentOp.getChild(arg)) != null) continue;
            return Optional.empty();
        }
        return Optional.of(currentOp);
    }

    static DataSchemaNode findChildSchemaNode(DataNodeContainer parent, QName child) {
        DataSchemaNode potential = parent.dataChildByName(child);
        return potential == null ? DataSchemaContextNode.findChoice(Iterables.filter((Iterable)parent.getChildNodes(), ChoiceSchemaNode.class), child) : potential;
    }

    static DataSchemaContextNode<?> fromSchemaAndQNameChecked(DataNodeContainer schema, QName child) {
        DataSchemaNode result = DataSchemaContextNode.findChildSchemaNode(schema, child);
        if (result != null && schema instanceof DataSchemaNode && result.isAugmenting()) {
            return DataSchemaContextNode.fromAugmentation(schema, (AugmentationTarget)schema, result);
        }
        return DataSchemaContextNode.lenientOf(result);
    }

    private static ChoiceSchemaNode findChoice(Iterable<ChoiceSchemaNode> choices, QName child) {
        for (ChoiceSchemaNode choice : choices) {
            for (CaseSchemaNode caze : choice.getCases()) {
                if (DataSchemaContextNode.findChildSchemaNode((DataNodeContainer)caze, child) == null) continue;
                return choice;
            }
        }
        return null;
    }

    public static YangInstanceIdentifier.AugmentationIdentifier augmentationIdentifierFrom(AugmentationSchemaNode schema) {
        return new YangInstanceIdentifier.AugmentationIdentifier(schema.getChildNodes().stream().map(SchemaNode::getQName).collect(Collectors.toSet()));
    }

    static @NonNull DataSchemaContextNode<?> of(@NonNull DataSchemaNode schema) {
        if (schema instanceof ContainerLike) {
            return new ContainerContextNode((ContainerLike)schema);
        }
        if (schema instanceof ListSchemaNode) {
            return DataSchemaContextNode.fromListSchemaNode((ListSchemaNode)schema);
        }
        if (schema instanceof LeafSchemaNode) {
            return new LeafContextNode((LeafSchemaNode)schema);
        }
        if (schema instanceof ChoiceSchemaNode) {
            return new ChoiceNodeContextNode((ChoiceSchemaNode)schema);
        }
        if (schema instanceof LeafListSchemaNode) {
            return DataSchemaContextNode.fromLeafListSchemaNode((LeafListSchemaNode)schema);
        }
        if (schema instanceof AnydataSchemaNode) {
            return new AnydataContextNode((AnydataSchemaNode)schema);
        }
        if (schema instanceof AnyxmlSchemaNode) {
            return new AnyXmlContextNode((AnyxmlSchemaNode)schema);
        }
        throw new IllegalStateException("Unhandled schema " + schema);
    }

    static @Nullable DataSchemaContextNode<?> lenientOf(@Nullable DataSchemaNode schema) {
        if (schema instanceof ContainerLike) {
            return new ContainerContextNode((ContainerLike)schema);
        }
        if (schema instanceof ListSchemaNode) {
            return DataSchemaContextNode.fromListSchemaNode((ListSchemaNode)schema);
        }
        if (schema instanceof LeafSchemaNode) {
            return new LeafContextNode((LeafSchemaNode)schema);
        }
        if (schema instanceof ChoiceSchemaNode) {
            return new ChoiceNodeContextNode((ChoiceSchemaNode)schema);
        }
        if (schema instanceof LeafListSchemaNode) {
            return DataSchemaContextNode.fromLeafListSchemaNode((LeafListSchemaNode)schema);
        }
        if (schema instanceof AnydataSchemaNode) {
            return new AnydataContextNode((AnydataSchemaNode)schema);
        }
        if (schema instanceof AnyxmlSchemaNode) {
            return new AnyXmlContextNode((AnyxmlSchemaNode)schema);
        }
        return null;
    }

    static @Nullable DataSchemaContextNode<?> fromAugmentation(DataNodeContainer parent, AugmentationTarget parentAug, DataSchemaNode child) {
        for (AugmentationSchemaNode aug : parentAug.getAvailableAugmentations()) {
            if (aug.dataChildByName(child.getQName()) == null) continue;
            return new AugmentationContextNode(aug, parent);
        }
        return DataSchemaContextNode.lenientOf(child);
    }

    @Deprecated(forRemoval=true, since="8.0.2")
    public static @Nullable DataSchemaContextNode<?> fromDataSchemaNode(DataSchemaNode potential) {
        return DataSchemaContextNode.lenientOf(potential);
    }

    private static @NonNull DataSchemaContextNode<?> fromListSchemaNode(ListSchemaNode potential) {
        List keyDefinition = potential.getKeyDefinition();
        if (keyDefinition.isEmpty()) {
            return new UnkeyedListMixinContextNode(potential);
        }
        if (potential.isUserOrdered()) {
            return new OrderedMapMixinContextNode(potential);
        }
        return new UnorderedMapMixinContextNode(potential);
    }

    private static @NonNull DataSchemaContextNode<?> fromLeafListSchemaNode(LeafListSchemaNode potential) {
        if (potential.isUserOrdered()) {
            return new OrderedLeafListMixinContextNode(potential);
        }
        return new UnorderedLeafListMixinContextNode(potential);
    }

    @Deprecated(forRemoval=true, since="8.0.2")
    public static @NonNull DataSchemaContextNode<?> from(EffectiveModelContext ctx) {
        return new ContainerContextNode((ContainerLike)ctx);
    }
}

