/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api;

import com.google.common.base.Verify;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.data.api.PathArgumentList;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

final class StackedPathArguments
extends PathArgumentList {
    private final List<YangInstanceIdentifier.PathArgument> base;
    private final List<YangInstanceIdentifier.PathArgument> stack;

    StackedPathArguments(@Nonnull YangInstanceIdentifier base, @Nonnull List<YangInstanceIdentifier.PathArgument> stack) {
        Verify.verify((!stack.isEmpty() ? 1 : 0) != 0);
        this.base = base.getPathArguments();
        this.stack = stack;
    }

    @Override
    public int size() {
        return this.stack.size() + this.base.size();
    }

    @Override
    public boolean contains(Object o) {
        YangInstanceIdentifier.PathArgument srch = (YangInstanceIdentifier.PathArgument)Objects.requireNonNull(o);
        return this.stack.contains(srch) || this.base.contains(srch);
    }

    @Override
    public YangInstanceIdentifier.PathArgument get(int index) {
        if (index < this.base.size()) {
            return this.base.get(index);
        }
        return this.stack.get(index - this.base.size());
    }

    @Override
    public int indexOf(Object o) {
        YangInstanceIdentifier.PathArgument srch = (YangInstanceIdentifier.PathArgument)Objects.requireNonNull(o);
        int ret = this.base.indexOf(srch);
        if (ret == -1 && (ret = this.stack.indexOf(srch)) != -1) {
            return this.base.size() + ret;
        }
        return ret;
    }

    @Override
    public int lastIndexOf(Object o) {
        YangInstanceIdentifier.PathArgument srch = (YangInstanceIdentifier.PathArgument)Objects.requireNonNull(o);
        int ret = this.stack.lastIndexOf(srch);
        if (ret != -1) {
            return this.base.size() + ret;
        }
        return this.base.lastIndexOf(srch);
    }

    @Override
    @Nonnull
    public UnmodifiableIterator<YangInstanceIdentifier.PathArgument> iterator() {
        return new IteratorImpl(this.base, this.stack);
    }

    private static final class IteratorImpl
    extends UnmodifiableIterator<YangInstanceIdentifier.PathArgument> {
        private final Iterator<YangInstanceIdentifier.PathArgument> stack;
        private final Iterator<YangInstanceIdentifier.PathArgument> base;

        IteratorImpl(Iterable<YangInstanceIdentifier.PathArgument> base, Iterable<YangInstanceIdentifier.PathArgument> stack) {
            this.base = base.iterator();
            this.stack = stack.iterator();
        }

        public boolean hasNext() {
            return this.stack.hasNext();
        }

        public YangInstanceIdentifier.PathArgument next() {
            if (this.base.hasNext()) {
                return this.base.next();
            }
            return this.stack.next();
        }
    }
}

