/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.serviceutils.srm.shell;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.EntityNameBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.EntityTypeBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.EntityTypeInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.EntityTypeService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.GeniusIfm;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.GeniusIfmInterface;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.GeniusItm;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.GeniusItmTep;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.GeniusItmTz;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtAcl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtAclInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtAclInterface;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtDhcp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtElan;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtElanInterface;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtL2gw;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtL2gwConnection;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtL2gwNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtQos;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtQosPolicyInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtVpn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.NetvirtVpnInstance;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.srm.types.rev180626.Ofplugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SrmCliUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SrmCliUtils.class);
    private static final ImmutableMap<String, Class<? extends EntityTypeBase>> ENTITY_TYPE_MAP = new ImmutableMap.Builder().put((Object)"SERVICE", EntityTypeService.class).put((Object)"INSTANCE", EntityTypeInstance.class).build();
    private static final ImmutableMap<String, Class<? extends EntityNameBase>> SERVICE_NAME_MAP = new ImmutableMap.Builder().put((Object)"ITM", GeniusItm.class).put((Object)"IFM", GeniusIfm.class).put((Object)"VPN", NetvirtVpn.class).put((Object)"ELAN", NetvirtElan.class).put((Object)"DHCP", NetvirtDhcp.class).put((Object)"L2GW", NetvirtL2gw.class).put((Object)"ACL", NetvirtAcl.class).put((Object)"OFPLUGIN", Ofplugin.class).put((Object)"QOS", NetvirtQos.class).build();
    private static final ImmutableMap<String, Class<? extends EntityNameBase>> INSTANCE_NAME_MAP = new ImmutableMap.Builder().put((Object)"ITM-TEP", GeniusItmTep.class).put((Object)"ITM-TZ", GeniusItmTz.class).put((Object)"IFM-IFACE", GeniusIfmInterface.class).put((Object)"VPN-INSTANCE", NetvirtVpnInstance.class).put((Object)"ELAN-INTERFACE", NetvirtElanInterface.class).put((Object)"L2GW-NODE", NetvirtL2gwNode.class).put((Object)"L2GW-CONNECTION", NetvirtL2gwConnection.class).put((Object)"QOS-POLICY-INSTANCE", NetvirtQosPolicyInstance.class).put((Object)"ACL-INTERFACE", NetvirtAclInterface.class).put((Object)"ACL-INSTANCE", NetvirtAclInstance.class).build();

    private SrmCliUtils() {
    }

    public static Class<? extends EntityTypeBase> getEntityType(String strType) {
        LOG.debug("Getting entityType for type {}", (Object)strType);
        return (Class)ENTITY_TYPE_MAP.get((Object)strType.toUpperCase(Locale.ROOT));
    }

    public static @Nullable Class<? extends EntityNameBase> getEntityName(Class<? extends EntityTypeBase> type, String strName) {
        LOG.debug("Getting entityName for type {} and name: {}", type, (Object)strName);
        if (EntityTypeService.class.equals(type)) {
            return (Class)SERVICE_NAME_MAP.get((Object)strName.toUpperCase(Locale.ROOT));
        }
        if (EntityTypeInstance.class.equals(type)) {
            return (Class)INSTANCE_NAME_MAP.get((Object)strName.toUpperCase(Locale.ROOT));
        }
        return null;
    }

    public static String getTypeHelp() {
        StringBuilder help = new StringBuilder("Supported Entity Types are:\n");
        for (String entityType : ENTITY_TYPE_MAP.keySet()) {
            help.append("\t").append(entityType).append("/").append(entityType.toLowerCase(Locale.ROOT)).append("\n");
        }
        return help.toString();
    }

    public static String getNameHelp(Class<? extends EntityTypeBase> entityType) {
        StringBuilder help;
        block3: {
            block2: {
                help = new StringBuilder("Supported Entity Names for type");
                if (!EntityTypeService.class.equals(entityType)) break block2;
                help.append(" SERVICE are:\n");
                for (String entityName : SERVICE_NAME_MAP.keySet()) {
                    help.append(String.format("\t%s/%s%n", entityName.toLowerCase(Locale.ROOT), entityName));
                }
                break block3;
            }
            if (!EntityTypeInstance.class.equals(entityType)) break block3;
            help.append(" INSTANCE are:\n");
            for (String entityName : INSTANCE_NAME_MAP.keySet()) {
                help.append(String.format("\t%s/%s%n", entityName.toLowerCase(Locale.ROOT), entityName));
            }
        }
        return help.toString();
    }
}

