/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.sdninterfaceapp.impl;

import com.google.common.base.Optional;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.binding.api.ReadTransaction;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.sdninterfaceapp.impl.PortStatistics;
import org.opendaylight.sdninterfaceapp.impl.database.SdniDataBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.GetAllNodeConnectorsStatisticsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.GetAllNodeConnectorsStatisticsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.GetAllPeerNodeConnectorsStatisticsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.GetAllPeerNodeConnectorsStatisticsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.OpendaylightSdniQosMsgService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.SdnControllers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.SdnControllersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.get.all.peer.node.connectors.statistics.output.Controllers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.get.all.peer.node.connectors.statistics.output.ControllersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.nodes.NodeList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.nodes.NodeListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.nodes.NodeListKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.nodes.node.list.PortList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.nodes.node.list.PortListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.nodes.node.list.port.list.PortParams;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.sdninterfaceapp.qos.msg.rev151006.nodes.node.list.port.list.PortParamsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.FlowCapableNodeConnectorStatisticsData;
import org.opendaylight.yang.gen.v1.urn.opendaylight.port.statistics.rev131214.flow.capable.node.connector.statistics.FlowCapableNodeConnectorStatistics;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpendaylightSdniQosMsgServiceImpl
implements OpendaylightSdniQosMsgService {
    private static OpendaylightSdniQosMsgServiceImpl serviceObj = null;
    private final Logger logger = LoggerFactory.getLogger(OpendaylightSdniQosMsgServiceImpl.class);
    private List<String> sdnControllers = new ArrayList<String>();
    private InstanceIdentifier<SdnControllers> instanceIdentifier = InstanceIdentifier.builder(SdnControllers.class).build();
    private DataBroker dataBroker;

    private OpendaylightSdniQosMsgServiceImpl() {
    }

    public static OpendaylightSdniQosMsgServiceImpl getInstance() {
        if (serviceObj == null) {
            serviceObj = new OpendaylightSdniQosMsgServiceImpl();
        }
        return serviceObj;
    }

    public Future<RpcResult<GetAllNodeConnectorsStatisticsOutput>> getAllNodeConnectorsStatistics() {
        ArrayList<NodeList> outputNodesList;
        GetAllNodeConnectorsStatisticsOutputBuilder builder;
        RpcResultBuilder rpcBuilder;
        GetAllNodeConnectorsStatisticsOutput output;
        String controller;
        block7: {
            this.logger.info("SdniQoSReader - getNodeConnectorStatistics :  Start");
            controller = null;
            output = null;
            rpcBuilder = null;
            builder = null;
            NodeList nodeList = null;
            outputNodesList = new ArrayList<NodeList>();
            try {
                controller = this.findIpAddress();
                ReadOnlyTransaction readTx = this.dataBroker.newReadOnlyTransaction();
                InstanceIdentifier NODES_IDENTIFIER = InstanceIdentifier.create(Nodes.class);
                Nodes nodes = (Nodes)this.getDataObject((ReadTransaction)readTx, NODES_IDENTIFIER);
                if (nodes != null) {
                    List nodesList = nodes.getNode();
                    if (nodesList == null || nodesList.isEmpty()) break block7;
                    for (Node node : nodesList) {
                        try {
                            nodeList = this.getAllPortStats(node, readTx);
                        }
                        catch (InterruptedException | ExecutionException | ReadFailedException e) {
                            this.logger.error("Exception in getAllNodeConnectorsStatistics : " + e.getMessage());
                        }
                        outputNodesList.add(nodeList);
                    }
                    break block7;
                }
                this.logger.error("in getAllNodeConnectorsStatistics : nodes : " + nodes);
            }
            catch (Exception e) {
                this.logger.error("Exception in getAllNodeConnectorsStatistics : " + e.getMessage());
                rpcBuilder = RpcResultBuilder.failed();
            }
        }
        builder = new GetAllNodeConnectorsStatisticsOutputBuilder();
        builder.setNodeList(outputNodesList);
        builder.setControllerIp(controller);
        if (!this.sdnControllers.contains(controller)) {
            this.sdnControllers.add(controller);
        }
        SdnControllersBuilder scb = new SdnControllersBuilder();
        scb.setSdnController(this.sdnControllers);
        WriteTransaction writeTx = this.dataBroker.newWriteOnlyTransaction();
        writeTx.merge(LogicalDatastoreType.OPERATIONAL, this.instanceIdentifier, (DataObject)scb.build());
        writeTx.commit();
        output = builder.build();
        rpcBuilder = RpcResultBuilder.success((Object)output);
        return rpcBuilder.buildFuture();
    }

    private <T extends DataObject> T getDataObject(ReadTransaction readOnlyTransaction, InstanceIdentifier<T> identifier) {
        Optional optionalData = null;
        try {
            optionalData = (Optional)readOnlyTransaction.read(LogicalDatastoreType.OPERATIONAL, identifier).get();
            if (optionalData.isPresent()) {
                return (T)((DataObject)optionalData.get());
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while executing getDataObject: " + e.getMessage());
        }
        return null;
    }

    private NodeList getAllPortStats(Node node, ReadOnlyTransaction readTx) throws ExecutionException, InterruptedException, ReadFailedException {
        FlowCapableNodeConnectorStatistics flow = null;
        NodeKey nodeKey = node.getKey();
        this.logger.info("In getAllPortStats nodekey : " + node.getId().getValue() + " : " + node.getKey());
        List ncList = node.getNodeConnector();
        if (ncList == null || ncList.isEmpty()) {
            return null;
        }
        this.logger.info("In getAllPortStats ncList size : " + node.getId().getValue() + " : " + ncList.size());
        ArrayList<PortList> portList = new ArrayList<PortList>();
        for (NodeConnector nc : ncList) {
            InstanceIdentifier connectorRef = InstanceIdentifier.create(Nodes.class).child(Node.class, (Identifier)nodeKey).child(NodeConnector.class, (Identifier)nc.getKey()).augmentation(FlowCapableNodeConnector.class);
            FlowCapableNodeConnector nodeConnector = (FlowCapableNodeConnector)this.getDataObject((ReadTransaction)readTx, connectorRef);
            this.logger.info("In getAllPortStats nodeConnector.getName() :{} ", (Object)nodeConnector.getName());
            KeyedInstanceIdentifier nodeConnectorII = InstanceIdentifier.create(Nodes.class).child(Node.class, (Identifier)nodeKey).child(NodeConnector.class, (Identifier)nc.getKey());
            Optional flowCapableNodeConnectorStatisticsDataOptional = (Optional)readTx.read(LogicalDatastoreType.OPERATIONAL, nodeConnectorII.augmentation(FlowCapableNodeConnectorStatisticsData.class)).checkedGet();
            if (!flowCapableNodeConnectorStatisticsDataOptional.isPresent()) continue;
            flow = ((FlowCapableNodeConnectorStatisticsData)flowCapableNodeConnectorStatisticsDataOptional.get()).getFlowCapableNodeConnectorStatistics();
            ArrayList<PortParams> portparams = new ArrayList<PortParams>();
            PortListBuilder portListBuilder = new PortListBuilder();
            portListBuilder.setPortId(nc.getId().getValue());
            PortParamsBuilder portparamsBuilder = new PortParamsBuilder();
            portparamsBuilder.setBytes(flow.getBytes());
            portparamsBuilder.setCollisionCount(flow.getCollisionCount());
            portparamsBuilder.setDuration(flow.getDuration());
            portparamsBuilder.setPackets(flow.getPackets());
            portparamsBuilder.setReceiveCrcError(flow.getReceiveCrcError());
            portparamsBuilder.setReceiveDrops(flow.getReceiveDrops());
            portparamsBuilder.setReceiveErrors(flow.getReceiveErrors());
            portparamsBuilder.setReceiveFrameError(flow.getReceiveFrameError());
            portparamsBuilder.setReceiveOverRunError(flow.getReceiveOverRunError());
            portparamsBuilder.setTransmitDrops(flow.getTransmitDrops());
            portparamsBuilder.setTransmitErrors(flow.getTransmitErrors());
            portparamsBuilder.setPortName(nodeConnector.getName());
            portparams.add(portparamsBuilder.build());
            portListBuilder.setPortParams(portparams);
            portList.add(portListBuilder.build());
        }
        NodeListBuilder nodeListBuilder = new NodeListBuilder();
        nodeListBuilder.setKey(new NodeListKey(node.getId().getValue()));
        nodeListBuilder.setNodeId(node.getId().getValue());
        nodeListBuilder.setPortList(portList);
        return nodeListBuilder.build();
    }

    private String findIpAddress() {
        Enumeration<NetworkInterface> e = null;
        try {
            e = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e1) {
            this.logger.error("Failed to get list of interfaces", (Throwable)e1);
            return null;
        }
        while (e.hasMoreElements()) {
            NetworkInterface n = e.nextElement();
            Enumeration<InetAddress> ee = n.getInetAddresses();
            while (ee.hasMoreElements()) {
                InetAddress i = ee.nextElement();
                this.logger.debug("Trying address {}", (Object)i);
                if (!(i instanceof Inet4Address) || i.isLoopbackAddress()) continue;
                String hostAddress = i.getHostAddress();
                this.logger.debug("Settled on controller address {}", (Object)hostAddress);
                return hostAddress;
            }
        }
        this.logger.error("Failed to find a suitable controller address");
        return null;
    }

    public Future<RpcResult<GetAllPeerNodeConnectorsStatisticsOutput>> getAllPeerNodeConnectorsStatistics() {
        this.logger.info("In getAllPeerNodeConnectorsStatistics START");
        GetAllPeerNodeConnectorsStatisticsOutputBuilder outputBuilder = new GetAllPeerNodeConnectorsStatisticsOutputBuilder();
        ArrayList<Controllers> controllers = new ArrayList<Controllers>();
        try {
            Set<String> controllersList;
            SdniDataBase sdb = SdniDataBase.getInstance();
            Map<String, Map<String, Map<String, PortStatistics>>> qosData = sdb.getAllQoSPeerData();
            if (qosData != null && !qosData.isEmpty() && (controllersList = qosData.keySet()) != null && !controllersList.isEmpty()) {
                this.logger.info("In getAllPeerNodeConnectorsStatistics controllersList : {}", (Object)controllersList.size());
                for (String controllerIp : controllersList) {
                    ControllersBuilder crtlBuilder = new ControllersBuilder();
                    ArrayList<NodeList> nodeList = new ArrayList<NodeList>();
                    Map<String, Map<String, PortStatistics>> nodeData = qosData.get(controllerIp);
                    if (nodeData != null && !nodeData.isEmpty()) {
                        this.logger.info("In getAllPeerNodeConnectorsStatistics nodeData : {}", (Object)nodeData.size());
                        Set<String> nodeNames = nodeData.keySet();
                        if (nodeNames != null && !nodeNames.isEmpty()) {
                            for (String nodeName : nodeNames) {
                                NodeListBuilder nLBuilder = new NodeListBuilder();
                                ArrayList<PortList> ports = new ArrayList<PortList>();
                                Map<String, PortStatistics> ncList = nodeData.get(nodeName);
                                if (ncList != null && !ncList.isEmpty()) {
                                    this.logger.info("In getAllPeerNodeConnectorsStatistics nodeConnectorList : {}", (Object)ncList.size());
                                    Set<String> portsList = ncList.keySet();
                                    if (portsList != null && !portsList.isEmpty()) {
                                        for (String port : portsList) {
                                            PortStatistics portStatistics = ncList.get(port);
                                            PortListBuilder portListBuilder = new PortListBuilder();
                                            ArrayList<PortParams> portparams = new ArrayList<PortParams>();
                                            PortParamsBuilder portparamsBuilder = new PortParamsBuilder();
                                            portparamsBuilder.setCollisionCount(new BigInteger(portStatistics.getCollisionCount()));
                                            portparamsBuilder.setReceiveCrcError(new BigInteger(portStatistics.getReceiveCrcError()));
                                            portparamsBuilder.setReceiveDrops(new BigInteger(portStatistics.getReceivePackets()));
                                            portparamsBuilder.setReceiveFrameError(new BigInteger(portStatistics.getReceiveFrameError()));
                                            portparamsBuilder.setReceiveOverRunError(new BigInteger(portStatistics.getReceiveOverRunError()));
                                            portparamsBuilder.setTransmitDrops(new BigInteger(portStatistics.getTransmitPackets()));
                                            portparams.add(portparamsBuilder.build());
                                            portListBuilder.setPortId(port);
                                            portListBuilder.setPortParams(portparams);
                                            ports.add(portListBuilder.build());
                                        }
                                    }
                                }
                                nLBuilder.setNodeId(nodeName);
                                nLBuilder.setPortList(ports);
                                nodeList.add(nLBuilder.build());
                            }
                        }
                    }
                    crtlBuilder.setControllerIp(controllerIp);
                    crtlBuilder.setNodeList(nodeList);
                    controllers.add(crtlBuilder.build());
                    if (this.sdnControllers.contains(controllerIp)) continue;
                    this.sdnControllers.add(controllerIp);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Exception in getAllPeerNodeConnectorsStatistics : {}", (Object)e.getMessage());
        }
        outputBuilder.setControllers(controllers);
        SdnControllersBuilder scb = new SdnControllersBuilder();
        scb.setSdnController(this.sdnControllers);
        WriteTransaction writeTx = this.dataBroker.newWriteOnlyTransaction();
        writeTx.merge(LogicalDatastoreType.OPERATIONAL, this.instanceIdentifier, (DataObject)scb.build());
        writeTx.commit();
        return RpcResultBuilder.success((Object)outputBuilder.build()).buildFuture();
    }

    public void setDataBroker(DataBroker dataBroker) {
        this.dataBroker = dataBroker;
    }
}

