/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.utils.mdsal.utils;

import java.util.ArrayList;
import org.opendaylight.ovsdb.utils.mdsal.utils.MdsalObject;
import org.opendaylight.ovsdb.utils.mdsal.utils.TransactionElement;
import org.opendaylight.ovsdb.utils.mdsal.utils.TransactionType;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class TransactionHistory
extends ArrayList<TransactionElement> {
    private static final long serialVersionUID = 1L;
    private final int capacity;
    private final int watermark;

    public TransactionHistory(int initialCapacity, int watermark) {
        super(initialCapacity);
        this.capacity = initialCapacity;
        this.watermark = watermark;
    }

    public void addToHistory(TransactionType updateType, Object object) {
        this.add(new TransactionElement(updateType, object));
    }

    public void addToHistory(TransactionType updateType, InstanceIdentifier iid, DataObject dataObject) {
        this.add(new TransactionElement(updateType, new MdsalObject(iid, dataObject)));
    }

    @Override
    public boolean add(TransactionElement element) {
        if (this.size() >= this.watermark) {
            this.removeRange(0, this.capacity - this.watermark);
        }
        return super.add(element);
    }

    public ArrayList<TransactionElement> getElements() {
        return new ArrayList<TransactionElement>(this);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
    }
}

