package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.add.match.from.value._case;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlowModAddMatchFromValueBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     FlowModAddMatchFromValueBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new FlowModAddMatchFromValueBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of FlowModAddMatchFromValueBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see FlowModAddMatchFromValueBuilder
 * @see Builder
 *
 */
public class FlowModAddMatchFromValueBuilder implements Builder<FlowModAddMatchFromValue> {

    private Integer _flowModNumBits;
    private Long _srcField;
    private Integer _srcOfs;
    private Integer _value;


    Map<Class<? extends Augmentation<FlowModAddMatchFromValue>>, Augmentation<FlowModAddMatchFromValue>> augmentation = Collections.emptyMap();

    public FlowModAddMatchFromValueBuilder() {
    }

    public FlowModAddMatchFromValueBuilder(FlowModAddMatchFromValue base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<FlowModAddMatchFromValue>>, Augmentation<FlowModAddMatchFromValue>> aug =((AugmentationHolder<FlowModAddMatchFromValue>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._flowModNumBits = base.getFlowModNumBits();
        this._srcField = base.getSrcField();
        this._srcOfs = base.getSrcOfs();
        this._value = base.getValue();
    }


    public Integer getFlowModNumBits() {
        return _flowModNumBits;
    }
    
    public Long getSrcField() {
        return _srcField;
    }
    
    public Integer getSrcOfs() {
        return _srcOfs;
    }
    
    public Integer getValue() {
        return _value;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowModAddMatchFromValue>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkFlowModNumBitsRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public FlowModAddMatchFromValueBuilder setFlowModNumBits(final Integer value) {
    if (value != null) {
        checkFlowModNumBitsRange(value);
        
    }
        this._flowModNumBits = value;
        return this;
    }
    private static void checkSrcFieldRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public FlowModAddMatchFromValueBuilder setSrcField(final Long value) {
    if (value != null) {
        checkSrcFieldRange(value);
        
    }
        this._srcField = value;
        return this;
    }
    private static void checkSrcOfsRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public FlowModAddMatchFromValueBuilder setSrcOfs(final Integer value) {
    if (value != null) {
        checkSrcOfsRange(value);
        
    }
        this._srcOfs = value;
        return this;
    }
    private static void checkValueRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public FlowModAddMatchFromValueBuilder setValue(final Integer value) {
    if (value != null) {
        checkValueRange(value);
        
    }
        this._value = value;
        return this;
    }
    
    public FlowModAddMatchFromValueBuilder addAugmentation(Class<? extends Augmentation<FlowModAddMatchFromValue>> augmentationType, Augmentation<FlowModAddMatchFromValue> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowModAddMatchFromValueBuilder removeAugmentation(Class<? extends Augmentation<FlowModAddMatchFromValue>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowModAddMatchFromValue build() {
        return new FlowModAddMatchFromValueImpl(this);
    }

    private static final class FlowModAddMatchFromValueImpl
        extends AbstractAugmentable<FlowModAddMatchFromValue>
        implements FlowModAddMatchFromValue {
    
        private final Integer _flowModNumBits;
        private final Long _srcField;
        private final Integer _srcOfs;
        private final Integer _value;
    
        FlowModAddMatchFromValueImpl(FlowModAddMatchFromValueBuilder base) {
            super(base.augmentation);
            this._flowModNumBits = base.getFlowModNumBits();
            this._srcField = base.getSrcField();
            this._srcOfs = base.getSrcOfs();
            this._value = base.getValue();
        }
    
        @Override
        public Integer getFlowModNumBits() {
            return _flowModNumBits;
        }
        
        @Override
        public Long getSrcField() {
            return _srcField;
        }
        
        @Override
        public Integer getSrcOfs() {
            return _srcOfs;
        }
        
        @Override
        public Integer getValue() {
            return _value;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flowModNumBits);
            result = prime * result + Objects.hashCode(_srcField);
            result = prime * result + Objects.hashCode(_srcOfs);
            result = prime * result + Objects.hashCode(_value);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowModAddMatchFromValue.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            FlowModAddMatchFromValue other = (FlowModAddMatchFromValue)obj;
            if (!Objects.equals(_flowModNumBits, other.getFlowModNumBits())) {
                return false;
            }
            if (!Objects.equals(_srcField, other.getSrcField())) {
                return false;
            }
            if (!Objects.equals(_srcOfs, other.getSrcOfs())) {
                return false;
            }
            if (!Objects.equals(_value, other.getValue())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowModAddMatchFromValueImpl otherImpl = (FlowModAddMatchFromValueImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowModAddMatchFromValue>>, Augmentation<FlowModAddMatchFromValue>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowModAddMatchFromValue");
            CodeHelpers.appendValue(helper, "_flowModNumBits", _flowModNumBits);
            CodeHelpers.appendValue(helper, "_srcField", _srcField);
            CodeHelpers.appendValue(helper, "_srcOfs", _srcOfs);
            CodeHelpers.appendValue(helper, "_value", _value);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
