package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Empty;

/**
 * Class that builds {@link DstNxNshc2CaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     DstNxNshc2CaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new DstNxNshc2CaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of DstNxNshc2CaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see DstNxNshc2CaseBuilder
 * @see Builder
 *
 */
public class DstNxNshc2CaseBuilder implements Builder<DstNxNshc2Case> {

    private Empty _nxNshc2Dst;


    Map<Class<? extends Augmentation<DstNxNshc2Case>>, Augmentation<DstNxNshc2Case>> augmentation = Collections.emptyMap();

    public DstNxNshc2CaseBuilder() {
    }
    public DstNxNshc2CaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping arg) {
        this._nxNshc2Dst = arg.getNxNshc2Dst();
    }

    public DstNxNshc2CaseBuilder(DstNxNshc2Case base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DstNxNshc2Case>>, Augmentation<DstNxNshc2Case>> aug =((AugmentationHolder<DstNxNshc2Case>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxNshc2Dst = base.getNxNshc2Dst();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping) {
            this._nxNshc2Dst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping)arg).getNxNshc2Dst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc2Grouping]");
    }

    public Empty getNxNshc2Dst() {
        return _nxNshc2Dst;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DstNxNshc2Case>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstNxNshc2CaseBuilder setNxNshc2Dst(final Empty value) {
        this._nxNshc2Dst = value;
        return this;
    }
    
    public DstNxNshc2CaseBuilder addAugmentation(Class<? extends Augmentation<DstNxNshc2Case>> augmentationType, Augmentation<DstNxNshc2Case> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstNxNshc2CaseBuilder removeAugmentation(Class<? extends Augmentation<DstNxNshc2Case>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstNxNshc2Case build() {
        return new DstNxNshc2CaseImpl(this);
    }

    private static final class DstNxNshc2CaseImpl
        extends AbstractAugmentable<DstNxNshc2Case>
        implements DstNxNshc2Case {
    
        private final Empty _nxNshc2Dst;
    
        DstNxNshc2CaseImpl(DstNxNshc2CaseBuilder base) {
            super(base.augmentation);
            this._nxNshc2Dst = base.getNxNshc2Dst();
        }
    
        @Override
        public Empty getNxNshc2Dst() {
            return _nxNshc2Dst;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxNshc2Dst);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstNxNshc2Case.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            DstNxNshc2Case other = (DstNxNshc2Case)obj;
            if (!Objects.equals(_nxNshc2Dst, other.getNxNshc2Dst())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstNxNshc2CaseImpl otherImpl = (DstNxNshc2CaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstNxNshc2Case>>, Augmentation<DstNxNshc2Case>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstNxNshc2Case");
            CodeHelpers.appendValue(helper, "_nxNshc2Dst", _nxNshc2Dst);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
