package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.Src;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * container nx-output-reg {
 *   container src {
 *     uses src-choice-grouping;
 *     leaf ofs_nbits {
 *       type uint16;
 *     }
 *   }
 *   leaf max_len {
 *     type uint16;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-action/nx-action-output-reg-grouping/nx-output-reg</i>
 *
 * <p>To create instances of this class use {@link NxOutputRegBuilder}.
 * @see NxOutputRegBuilder
 *
 */
public interface NxOutputReg
    extends
    ChildOf<NxActionOutputRegGrouping>,
    Augmentable<NxOutputReg>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("nx-output-reg");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.NxOutputReg> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.NxOutputReg.class;
    }
    
    /**
     * Choose the register with the OpenFlow output port, using the number of bits
     * specified from the register.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.Src</code> <code>src</code>, or <code>null</code> if not present
     */
    @Nullable Src getSrc();
    
    /**
     * The number of bytes to send when the chosen port is OFPP_CONTROLLER
     *
     *
     *
     * @return <code>java.lang.Integer</code> <code>maxLen</code>, or <code>null</code> if not present
     */
    @Nullable Integer getMaxLen();

}

