package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Empty;

/**
 * Class that builds {@link SrcOfArpOpCaseBuilder} instances.
 *
 * @see SrcOfArpOpCaseBuilder
 *
 */
public class SrcOfArpOpCaseBuilder implements Builder<SrcOfArpOpCase> {

    private Empty _ofArpOp;


    Map<Class<? extends Augmentation<SrcOfArpOpCase>>, Augmentation<SrcOfArpOpCase>> augmentation = Collections.emptyMap();

    public SrcOfArpOpCaseBuilder() {
    }
    public SrcOfArpOpCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfArpOpGrouping arg) {
        this._ofArpOp = arg.getOfArpOp();
    }

    public SrcOfArpOpCaseBuilder(SrcOfArpOpCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcOfArpOpCase>>, Augmentation<SrcOfArpOpCase>> aug =((AugmentationHolder<SrcOfArpOpCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._ofArpOp = base.getOfArpOp();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfArpOpGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfArpOpGrouping) {
            this._ofArpOp = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfArpOpGrouping)arg).getOfArpOp();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfArpOpGrouping]");
    }

    public Empty getOfArpOp() {
        return _ofArpOp;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcOfArpOpCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcOfArpOpCaseBuilder setOfArpOp(final Empty value) {
        this._ofArpOp = value;
        return this;
    }
    
    public SrcOfArpOpCaseBuilder addAugmentation(Class<? extends Augmentation<SrcOfArpOpCase>> augmentationType, Augmentation<SrcOfArpOpCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcOfArpOpCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcOfArpOpCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcOfArpOpCase build() {
        return new SrcOfArpOpCaseImpl(this);
    }

    private static final class SrcOfArpOpCaseImpl
        extends AbstractAugmentable<SrcOfArpOpCase>
        implements SrcOfArpOpCase {
    
        private final Empty _ofArpOp;
    
        SrcOfArpOpCaseImpl(SrcOfArpOpCaseBuilder base) {
            super(base.augmentation);
            this._ofArpOp = base.getOfArpOp();
        }
    
        @Override
        public Empty getOfArpOp() {
            return _ofArpOp;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ofArpOp);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcOfArpOpCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            SrcOfArpOpCase other = (SrcOfArpOpCase)obj;
            if (!Objects.equals(_ofArpOp, other.getOfArpOp())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcOfArpOpCaseImpl otherImpl = (SrcOfArpOpCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcOfArpOpCase>>, Augmentation<SrcOfArpOpCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcOfArpOpCase");
            CodeHelpers.appendValue(helper, "_ofArpOp", _ofArpOp);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
