package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxHashFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxMpAlgorithm;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.nx.multipath.Dst;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * container nx-multipath {
 *   leaf fields {
 *     type nicira-action:ofj-nx-hash-fields;
 *   }
 *   leaf basis {
 *     type uint16;
 *     default 0x400;
 *   }
 *   leaf algorithm {
 *     type nicira-action:ofj-nx-mp-algorithm;
 *   }
 *   leaf max-link {
 *     type uint16;
 *   }
 *   leaf arg {
 *     type uint32;
 *   }
 *   container dst {
 *     uses dst-choice-grouping;
 *     uses range-grouping;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-action/nx-action-multipath-grouping/nx-multipath</i>
 *
 * <p>To create instances of this class use {@link NxMultipathBuilder}.
 * @see NxMultipathBuilder
 *
 */
public interface NxMultipath
    extends
    ChildOf<NxActionMultipathGrouping>,
    Augmentable<NxMultipath>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("nx-multipath");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxHashFields</code> <code>fields</code>, or <code>null</code> if not present
     */
    @Nullable OfjNxHashFields getFields();
    
    /**
     * @return <code>java.lang.Integer</code> <code>basis</code>, or <code>null</code> if not present
     */
    @Nullable Integer getBasis();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxMpAlgorithm</code> <code>algorithm</code>, or <code>null</code> if not present
     */
    @Nullable OfjNxMpAlgorithm getAlgorithm();
    
    /**
     * @return <code>java.lang.Integer</code> <code>maxLink</code>, or <code>null</code> if not present
     */
    @Nullable Integer getMaxLink();
    
    /**
     * @return <code>java.lang.Long</code> <code>arg</code>, or <code>null</code> if not present
     */
    @Nullable Long getArg();
    
    /**
     * Writes value to bits start through end, inclusive, in field dst.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.nx.multipath.Dst</code> <code>dst</code>, or <code>null</code> if not present
     */
    @Nullable Dst getDst();

}

