package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.fin.timeout.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionFinTimeoutBuilder} instances.
 *
 * @see NxActionFinTimeoutBuilder
 *
 */
public class NxActionFinTimeoutBuilder implements Builder<NxActionFinTimeout> {

    private Integer _finHardTimeout;
    private Integer _finIdleTimeout;


    Map<Class<? extends Augmentation<NxActionFinTimeout>>, Augmentation<NxActionFinTimeout>> augmentation = Collections.emptyMap();

    public NxActionFinTimeoutBuilder() {
    }

    public NxActionFinTimeoutBuilder(NxActionFinTimeout base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionFinTimeout>>, Augmentation<NxActionFinTimeout>> aug =((AugmentationHolder<NxActionFinTimeout>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._finHardTimeout = base.getFinHardTimeout();
        this._finIdleTimeout = base.getFinIdleTimeout();
    }


    public Integer getFinHardTimeout() {
        return _finHardTimeout;
    }
    
    public Integer getFinIdleTimeout() {
        return _finIdleTimeout;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionFinTimeout>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkFinHardTimeoutRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public NxActionFinTimeoutBuilder setFinHardTimeout(final Integer value) {
    if (value != null) {
        checkFinHardTimeoutRange(value);
        
    }
        this._finHardTimeout = value;
        return this;
    }
    private static void checkFinIdleTimeoutRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public NxActionFinTimeoutBuilder setFinIdleTimeout(final Integer value) {
    if (value != null) {
        checkFinIdleTimeoutRange(value);
        
    }
        this._finIdleTimeout = value;
        return this;
    }
    
    public NxActionFinTimeoutBuilder addAugmentation(Class<? extends Augmentation<NxActionFinTimeout>> augmentationType, Augmentation<NxActionFinTimeout> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionFinTimeoutBuilder removeAugmentation(Class<? extends Augmentation<NxActionFinTimeout>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionFinTimeout build() {
        return new NxActionFinTimeoutImpl(this);
    }

    private static final class NxActionFinTimeoutImpl
        extends AbstractAugmentable<NxActionFinTimeout>
        implements NxActionFinTimeout {
    
        private final Integer _finHardTimeout;
        private final Integer _finIdleTimeout;
    
        NxActionFinTimeoutImpl(NxActionFinTimeoutBuilder base) {
            super(base.augmentation);
            this._finHardTimeout = base.getFinHardTimeout();
            this._finIdleTimeout = base.getFinIdleTimeout();
        }
    
        @Override
        public Integer getFinHardTimeout() {
            return _finHardTimeout;
        }
        
        @Override
        public Integer getFinIdleTimeout() {
            return _finIdleTimeout;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_finHardTimeout);
            result = prime * result + Objects.hashCode(_finIdleTimeout);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionFinTimeout.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            NxActionFinTimeout other = (NxActionFinTimeout)obj;
            if (!Objects.equals(_finHardTimeout, other.getFinHardTimeout())) {
                return false;
            }
            if (!Objects.equals(_finIdleTimeout, other.getFinIdleTimeout())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionFinTimeoutImpl otherImpl = (NxActionFinTimeoutImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionFinTimeout>>, Augmentation<NxActionFinTimeout>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionFinTimeout");
            CodeHelpers.appendValue(helper, "_finHardTimeout", _finHardTimeout);
            CodeHelpers.appendValue(helper, "_finIdleTimeout", _finIdleTimeout);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
