package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.copy.value.into.field._case;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlowModCopyValueIntoFieldBuilder} instances.
 *
 * @see FlowModCopyValueIntoFieldBuilder
 *
 */
public class FlowModCopyValueIntoFieldBuilder implements Builder<FlowModCopyValueIntoField> {

    private Long _dstField;
    private Integer _dstOfs;
    private Integer _flowModNumBits;
    private Integer _value;


    Map<Class<? extends Augmentation<FlowModCopyValueIntoField>>, Augmentation<FlowModCopyValueIntoField>> augmentation = Collections.emptyMap();

    public FlowModCopyValueIntoFieldBuilder() {
    }

    public FlowModCopyValueIntoFieldBuilder(FlowModCopyValueIntoField base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<FlowModCopyValueIntoField>>, Augmentation<FlowModCopyValueIntoField>> aug =((AugmentationHolder<FlowModCopyValueIntoField>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._dstField = base.getDstField();
        this._dstOfs = base.getDstOfs();
        this._flowModNumBits = base.getFlowModNumBits();
        this._value = base.getValue();
    }


    public Long getDstField() {
        return _dstField;
    }
    
    public Integer getDstOfs() {
        return _dstOfs;
    }
    
    public Integer getFlowModNumBits() {
        return _flowModNumBits;
    }
    
    public Integer getValue() {
        return _value;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowModCopyValueIntoField>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkDstFieldRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public FlowModCopyValueIntoFieldBuilder setDstField(final Long value) {
    if (value != null) {
        checkDstFieldRange(value);
        
    }
        this._dstField = value;
        return this;
    }
    private static void checkDstOfsRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public FlowModCopyValueIntoFieldBuilder setDstOfs(final Integer value) {
    if (value != null) {
        checkDstOfsRange(value);
        
    }
        this._dstOfs = value;
        return this;
    }
    private static void checkFlowModNumBitsRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public FlowModCopyValueIntoFieldBuilder setFlowModNumBits(final Integer value) {
    if (value != null) {
        checkFlowModNumBitsRange(value);
        
    }
        this._flowModNumBits = value;
        return this;
    }
    private static void checkValueRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public FlowModCopyValueIntoFieldBuilder setValue(final Integer value) {
    if (value != null) {
        checkValueRange(value);
        
    }
        this._value = value;
        return this;
    }
    
    public FlowModCopyValueIntoFieldBuilder addAugmentation(Class<? extends Augmentation<FlowModCopyValueIntoField>> augmentationType, Augmentation<FlowModCopyValueIntoField> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowModCopyValueIntoFieldBuilder removeAugmentation(Class<? extends Augmentation<FlowModCopyValueIntoField>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowModCopyValueIntoField build() {
        return new FlowModCopyValueIntoFieldImpl(this);
    }

    private static final class FlowModCopyValueIntoFieldImpl
        extends AbstractAugmentable<FlowModCopyValueIntoField>
        implements FlowModCopyValueIntoField {
    
        private final Long _dstField;
        private final Integer _dstOfs;
        private final Integer _flowModNumBits;
        private final Integer _value;
    
        FlowModCopyValueIntoFieldImpl(FlowModCopyValueIntoFieldBuilder base) {
            super(base.augmentation);
            this._dstField = base.getDstField();
            this._dstOfs = base.getDstOfs();
            this._flowModNumBits = base.getFlowModNumBits();
            this._value = base.getValue();
        }
    
        @Override
        public Long getDstField() {
            return _dstField;
        }
        
        @Override
        public Integer getDstOfs() {
            return _dstOfs;
        }
        
        @Override
        public Integer getFlowModNumBits() {
            return _flowModNumBits;
        }
        
        @Override
        public Integer getValue() {
            return _value;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_dstField);
            result = prime * result + Objects.hashCode(_dstOfs);
            result = prime * result + Objects.hashCode(_flowModNumBits);
            result = prime * result + Objects.hashCode(_value);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowModCopyValueIntoField.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            FlowModCopyValueIntoField other = (FlowModCopyValueIntoField)obj;
            if (!Objects.equals(_dstField, other.getDstField())) {
                return false;
            }
            if (!Objects.equals(_dstOfs, other.getDstOfs())) {
                return false;
            }
            if (!Objects.equals(_flowModNumBits, other.getFlowModNumBits())) {
                return false;
            }
            if (!Objects.equals(_value, other.getValue())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowModCopyValueIntoFieldImpl otherImpl = (FlowModCopyValueIntoFieldImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowModCopyValueIntoField>>, Augmentation<FlowModCopyValueIntoField>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowModCopyValueIntoField");
            CodeHelpers.appendValue(helper, "_dstField", _dstField);
            CodeHelpers.appendValue(helper, "_dstOfs", _dstOfs);
            CodeHelpers.appendValue(helper, "_flowModNumBits", _flowModNumBits);
            CodeHelpers.appendValue(helper, "_value", _value);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
