package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Empty;

/**
 * Class that builds {@link DstOfIcmpTypeCaseBuilder} instances.
 *
 * @see DstOfIcmpTypeCaseBuilder
 *
 */
public class DstOfIcmpTypeCaseBuilder implements Builder<DstOfIcmpTypeCase> {

    private Empty _ofIcmpType;


    Map<Class<? extends Augmentation<DstOfIcmpTypeCase>>, Augmentation<DstOfIcmpTypeCase>> augmentation = Collections.emptyMap();

    public DstOfIcmpTypeCaseBuilder() {
    }
    public DstOfIcmpTypeCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIcmpTypeGrouping arg) {
        this._ofIcmpType = arg.getOfIcmpType();
    }

    public DstOfIcmpTypeCaseBuilder(DstOfIcmpTypeCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DstOfIcmpTypeCase>>, Augmentation<DstOfIcmpTypeCase>> aug =((AugmentationHolder<DstOfIcmpTypeCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._ofIcmpType = base.getOfIcmpType();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIcmpTypeGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIcmpTypeGrouping) {
            this._ofIcmpType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIcmpTypeGrouping)arg).getOfIcmpType();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfIcmpTypeGrouping]");
    }

    public Empty getOfIcmpType() {
        return _ofIcmpType;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DstOfIcmpTypeCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstOfIcmpTypeCaseBuilder setOfIcmpType(final Empty value) {
        this._ofIcmpType = value;
        return this;
    }
    
    public DstOfIcmpTypeCaseBuilder addAugmentation(Class<? extends Augmentation<DstOfIcmpTypeCase>> augmentationType, Augmentation<DstOfIcmpTypeCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstOfIcmpTypeCaseBuilder removeAugmentation(Class<? extends Augmentation<DstOfIcmpTypeCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstOfIcmpTypeCase build() {
        return new DstOfIcmpTypeCaseImpl(this);
    }

    private static final class DstOfIcmpTypeCaseImpl
        extends AbstractAugmentable<DstOfIcmpTypeCase>
        implements DstOfIcmpTypeCase {
    
        private final Empty _ofIcmpType;
    
        DstOfIcmpTypeCaseImpl(DstOfIcmpTypeCaseBuilder base) {
            super(base.augmentation);
            this._ofIcmpType = base.getOfIcmpType();
        }
    
        @Override
        public Empty getOfIcmpType() {
            return _ofIcmpType;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ofIcmpType);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstOfIcmpTypeCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            DstOfIcmpTypeCase other = (DstOfIcmpTypeCase)obj;
            if (!Objects.equals(_ofIcmpType, other.getOfIcmpType())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstOfIcmpTypeCaseImpl otherImpl = (DstOfIcmpTypeCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstOfIcmpTypeCase>>, Augmentation<DstOfIcmpTypeCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstOfIcmpTypeCase");
            CodeHelpers.appendValue(helper, "_ofIcmpType", _ofIcmpType);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
