package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Empty;

/**
 * Class that builds {@link DstNxTunIpv4DstCaseBuilder} instances.
 *
 * @see DstNxTunIpv4DstCaseBuilder
 *
 */
public class DstNxTunIpv4DstCaseBuilder implements Builder<DstNxTunIpv4DstCase> {

    private Empty _nxTunIpv4Dst;


    Map<Class<? extends Augmentation<DstNxTunIpv4DstCase>>, Augmentation<DstNxTunIpv4DstCase>> augmentation = Collections.emptyMap();

    public DstNxTunIpv4DstCaseBuilder() {
    }
    public DstNxTunIpv4DstCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4DstGrouping arg) {
        this._nxTunIpv4Dst = arg.getNxTunIpv4Dst();
    }

    public DstNxTunIpv4DstCaseBuilder(DstNxTunIpv4DstCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DstNxTunIpv4DstCase>>, Augmentation<DstNxTunIpv4DstCase>> aug =((AugmentationHolder<DstNxTunIpv4DstCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxTunIpv4Dst = base.getNxTunIpv4Dst();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4DstGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4DstGrouping) {
            this._nxTunIpv4Dst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4DstGrouping)arg).getNxTunIpv4Dst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4DstGrouping]");
    }

    public Empty getNxTunIpv4Dst() {
        return _nxTunIpv4Dst;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DstNxTunIpv4DstCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstNxTunIpv4DstCaseBuilder setNxTunIpv4Dst(final Empty value) {
        this._nxTunIpv4Dst = value;
        return this;
    }
    
    public DstNxTunIpv4DstCaseBuilder addAugmentation(Class<? extends Augmentation<DstNxTunIpv4DstCase>> augmentationType, Augmentation<DstNxTunIpv4DstCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstNxTunIpv4DstCaseBuilder removeAugmentation(Class<? extends Augmentation<DstNxTunIpv4DstCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstNxTunIpv4DstCase build() {
        return new DstNxTunIpv4DstCaseImpl(this);
    }

    private static final class DstNxTunIpv4DstCaseImpl
        extends AbstractAugmentable<DstNxTunIpv4DstCase>
        implements DstNxTunIpv4DstCase {
    
        private final Empty _nxTunIpv4Dst;
    
        DstNxTunIpv4DstCaseImpl(DstNxTunIpv4DstCaseBuilder base) {
            super(base.augmentation);
            this._nxTunIpv4Dst = base.getNxTunIpv4Dst();
        }
    
        @Override
        public Empty getNxTunIpv4Dst() {
            return _nxTunIpv4Dst;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxTunIpv4Dst);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstNxTunIpv4DstCase.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            DstNxTunIpv4DstCase other = (DstNxTunIpv4DstCase)obj;
            if (!Objects.equals(_nxTunIpv4Dst, other.getNxTunIpv4Dst())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstNxTunIpv4DstCaseImpl otherImpl = (DstNxTunIpv4DstCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstNxTunIpv4DstCase>>, Augmentation<DstNxTunIpv4DstCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstNxTunIpv4DstCase");
            CodeHelpers.appendValue(helper, "_nxTunIpv4Dst", _nxTunIpv4Dst);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
