/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.ct.mark._case;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.ct.mark._case.NxActionCtMark;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxActionCtMarkBuilder
implements Builder<NxActionCtMark> {
    private Long _ctMark;
    Map<Class<? extends Augmentation<NxActionCtMark>>, Augmentation<NxActionCtMark>> augmentation = Collections.emptyMap();

    public NxActionCtMarkBuilder() {
    }

    public NxActionCtMarkBuilder(NxActionCtMark base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionCtMark>>, Augmentation<NxActionCtMark>>(aug);
        }
        this._ctMark = base.getCtMark();
    }

    public Long getCtMark() {
        return this._ctMark;
    }

    public <E$$ extends Augmentation<NxActionCtMark>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkCtMarkRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public NxActionCtMarkBuilder setCtMark(Long value) {
        if (value != null) {
            NxActionCtMarkBuilder.checkCtMarkRange(value);
        }
        this._ctMark = value;
        return this;
    }

    public NxActionCtMarkBuilder addAugmentation(Class<? extends Augmentation<NxActionCtMark>> augmentationType, Augmentation<NxActionCtMark> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionCtMark>>, Augmentation<NxActionCtMark>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NxActionCtMarkBuilder removeAugmentation(Class<? extends Augmentation<NxActionCtMark>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxActionCtMark build() {
        return new NxActionCtMarkImpl(this);
    }

    private static final class NxActionCtMarkImpl
    extends AbstractAugmentable<NxActionCtMark>
    implements NxActionCtMark {
        private final Long _ctMark;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NxActionCtMarkImpl(NxActionCtMarkBuilder base) {
            super(base.augmentation);
            this._ctMark = base.getCtMark();
        }

        public Class<NxActionCtMark> getImplementedInterface() {
            return NxActionCtMark.class;
        }

        @Override
        public Long getCtMark() {
            return this._ctMark;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ctMark);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionCtMark.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionCtMark other = (NxActionCtMark)obj;
            if (!Objects.equals(this._ctMark, other.getCtMark())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxActionCtMarkImpl otherImpl = (NxActionCtMarkImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NxActionCtMark");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ctMark", (Object)this._ctMark);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

