/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.NxOutputReg;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.Src;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxOutputRegBuilder
implements Builder<NxOutputReg> {
    private Integer _maxLen;
    private Src _src;
    Map<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>> augmentation = Collections.emptyMap();

    public NxOutputRegBuilder() {
    }

    public NxOutputRegBuilder(NxOutputReg base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>>(aug);
        }
        this._maxLen = base.getMaxLen();
        this._src = base.getSrc();
    }

    public Integer getMaxLen() {
        return this._maxLen;
    }

    public Src getSrc() {
        return this._src;
    }

    public <E$$ extends Augmentation<NxOutputReg>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkMaxLenRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public NxOutputRegBuilder setMaxLen(Integer value) {
        if (value != null) {
            NxOutputRegBuilder.checkMaxLenRange(value);
        }
        this._maxLen = value;
        return this;
    }

    public NxOutputRegBuilder setSrc(Src value) {
        this._src = value;
        return this;
    }

    public NxOutputRegBuilder addAugmentation(Class<? extends Augmentation<NxOutputReg>> augmentationType, Augmentation<NxOutputReg> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NxOutputRegBuilder removeAugmentation(Class<? extends Augmentation<NxOutputReg>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxOutputReg build() {
        return new NxOutputRegImpl(this);
    }

    private static final class NxOutputRegImpl
    extends AbstractAugmentable<NxOutputReg>
    implements NxOutputReg {
        private final Integer _maxLen;
        private final Src _src;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NxOutputRegImpl(NxOutputRegBuilder base) {
            super(base.augmentation);
            this._maxLen = base.getMaxLen();
            this._src = base.getSrc();
        }

        public Class<NxOutputReg> getImplementedInterface() {
            return NxOutputReg.class;
        }

        @Override
        public Integer getMaxLen() {
            return this._maxLen;
        }

        @Override
        public Src getSrc() {
            return this._src;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._maxLen);
            result = 31 * result + Objects.hashCode(this._src);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxOutputReg.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxOutputReg other = (NxOutputReg)obj;
            if (!Objects.equals(this._maxLen, other.getMaxLen())) {
                return false;
            }
            if (!Objects.equals(this._src, other.getSrc())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxOutputRegImpl otherImpl = (NxOutputRegImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NxOutputReg");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_maxLen", (Object)this._maxLen);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_src", (Object)this._src);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

