/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.nx.conntrack.CtActions;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxConntrackBuilder
implements Builder<NxConntrack> {
    private Integer _conntrackZone;
    private List<CtActions> _ctActions;
    private Integer _flags;
    private Short _recircTable;
    private Long _zoneSrc;
    Map<Class<? extends Augmentation<NxConntrack>>, Augmentation<NxConntrack>> augmentation = Collections.emptyMap();

    public NxConntrackBuilder() {
    }

    public NxConntrackBuilder(NxConntrack base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxConntrack>>, Augmentation<NxConntrack>>(aug);
        }
        this._conntrackZone = base.getConntrackZone();
        this._ctActions = base.getCtActions();
        this._flags = base.getFlags();
        this._recircTable = base.getRecircTable();
        this._zoneSrc = base.getZoneSrc();
    }

    public Integer getConntrackZone() {
        return this._conntrackZone;
    }

    public List<CtActions> getCtActions() {
        return this._ctActions;
    }

    public Integer getFlags() {
        return this._flags;
    }

    public Short getRecircTable() {
        return this._recircTable;
    }

    public Long getZoneSrc() {
        return this._zoneSrc;
    }

    public <E$$ extends Augmentation<NxConntrack>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkConntrackZoneRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public NxConntrackBuilder setConntrackZone(Integer value) {
        if (value != null) {
            NxConntrackBuilder.checkConntrackZoneRange(value);
        }
        this._conntrackZone = value;
        return this;
    }

    public NxConntrackBuilder setCtActions(List<CtActions> values) {
        this._ctActions = values;
        return this;
    }

    private static void checkFlagsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public NxConntrackBuilder setFlags(Integer value) {
        if (value != null) {
            NxConntrackBuilder.checkFlagsRange(value);
        }
        this._flags = value;
        return this;
    }

    private static void checkRecircTableRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..255]]", (int)value);
    }

    public NxConntrackBuilder setRecircTable(Short value) {
        if (value != null) {
            NxConntrackBuilder.checkRecircTableRange(value);
        }
        this._recircTable = value;
        return this;
    }

    private static void checkZoneSrcRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..4294967295]]", (long)value);
    }

    public NxConntrackBuilder setZoneSrc(Long value) {
        if (value != null) {
            NxConntrackBuilder.checkZoneSrcRange(value);
        }
        this._zoneSrc = value;
        return this;
    }

    public NxConntrackBuilder addAugmentation(Class<? extends Augmentation<NxConntrack>> augmentationType, Augmentation<NxConntrack> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxConntrack>>, Augmentation<NxConntrack>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NxConntrackBuilder removeAugmentation(Class<? extends Augmentation<NxConntrack>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxConntrack build() {
        return new NxConntrackImpl(this);
    }

    private static final class NxConntrackImpl
    extends AbstractAugmentable<NxConntrack>
    implements NxConntrack {
        private final Integer _conntrackZone;
        private final List<CtActions> _ctActions;
        private final Integer _flags;
        private final Short _recircTable;
        private final Long _zoneSrc;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NxConntrackImpl(NxConntrackBuilder base) {
            super(base.augmentation);
            this._conntrackZone = base.getConntrackZone();
            this._ctActions = base.getCtActions();
            this._flags = base.getFlags();
            this._recircTable = base.getRecircTable();
            this._zoneSrc = base.getZoneSrc();
        }

        public Class<NxConntrack> getImplementedInterface() {
            return NxConntrack.class;
        }

        @Override
        public Integer getConntrackZone() {
            return this._conntrackZone;
        }

        @Override
        public List<CtActions> getCtActions() {
            return this._ctActions;
        }

        @Override
        public Integer getFlags() {
            return this._flags;
        }

        @Override
        public Short getRecircTable() {
            return this._recircTable;
        }

        @Override
        public Long getZoneSrc() {
            return this._zoneSrc;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._conntrackZone);
            result = 31 * result + Objects.hashCode(this._ctActions);
            result = 31 * result + Objects.hashCode(this._flags);
            result = 31 * result + Objects.hashCode(this._recircTable);
            result = 31 * result + Objects.hashCode(this._zoneSrc);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxConntrack.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxConntrack other = (NxConntrack)obj;
            if (!Objects.equals(this._conntrackZone, other.getConntrackZone())) {
                return false;
            }
            if (!Objects.equals(this._ctActions, other.getCtActions())) {
                return false;
            }
            if (!Objects.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._recircTable, other.getRecircTable())) {
                return false;
            }
            if (!Objects.equals(this._zoneSrc, other.getZoneSrc())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxConntrackImpl otherImpl = (NxConntrackImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NxConntrack");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_conntrackZone", (Object)this._conntrackZone);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ctActions", this._ctActions);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_flags", (Object)this._flags);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_recircTable", (Object)this._recircTable);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_zoneSrc", (Object)this._zoneSrc);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

