package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.tcp.dst.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxmOfTcpDstBuilder} instances.
 *
 * @see NxmOfTcpDstBuilder
 *
 */
public class NxmOfTcpDstBuilder implements Builder<NxmOfTcpDst> {

    private Integer _mask;
    private PortNumber _port;


    Map<Class<? extends Augmentation<NxmOfTcpDst>>, Augmentation<NxmOfTcpDst>> augmentation = Collections.emptyMap();

    public NxmOfTcpDstBuilder() {
    }

    public NxmOfTcpDstBuilder(NxmOfTcpDst base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxmOfTcpDst>>, Augmentation<NxmOfTcpDst>> aug =((AugmentationHolder<NxmOfTcpDst>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._mask = base.getMask();
        this._port = base.getPort();
    }


    public Integer getMask() {
        return _mask;
    }
    
    public PortNumber getPort() {
        return _port;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxmOfTcpDst>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkMaskRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public NxmOfTcpDstBuilder setMask(final Integer value) {
    if (value != null) {
        checkMaskRange(value);
        
    }
        this._mask = value;
        return this;
    }
    
    public NxmOfTcpDstBuilder setPort(final PortNumber value) {
        this._port = value;
        return this;
    }
    
    public NxmOfTcpDstBuilder addAugmentation(Class<? extends Augmentation<NxmOfTcpDst>> augmentationType, Augmentation<NxmOfTcpDst> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxmOfTcpDstBuilder removeAugmentation(Class<? extends Augmentation<NxmOfTcpDst>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmOfTcpDst build() {
        return new NxmOfTcpDstImpl(this);
    }

    private static final class NxmOfTcpDstImpl
        extends AbstractAugmentable<NxmOfTcpDst>
        implements NxmOfTcpDst {
    
        private final Integer _mask;
        private final PortNumber _port;
    
        NxmOfTcpDstImpl(NxmOfTcpDstBuilder base) {
            super(base.augmentation);
            this._mask = base.getMask();
            this._port = base.getPort();
        }
    
        @Override
        public Class<NxmOfTcpDst> getImplementedInterface() {
            return NxmOfTcpDst.class;
        }
    
        @Override
        public Integer getMask() {
            return _mask;
        }
        
        @Override
        public PortNumber getPort() {
            return _port;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_mask);
            result = prime * result + Objects.hashCode(_port);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmOfTcpDst.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmOfTcpDst other = (NxmOfTcpDst)obj;
            if (!Objects.equals(_mask, other.getMask())) {
                return false;
            }
            if (!Objects.equals(_port, other.getPort())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxmOfTcpDstImpl otherImpl = (NxmOfTcpDstImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxmOfTcpDst>>, Augmentation<NxmOfTcpDst>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmOfTcpDst");
            CodeHelpers.appendValue(helper, "_mask", _mask);
            CodeHelpers.appendValue(helper, "_port", _port);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
