package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nshc._2.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxmNxNshc2Builder} instances.
 *
 * @see NxmNxNshc2Builder
 *
 */
public class NxmNxNshc2Builder implements Builder<NxmNxNshc2> {

    private Long _mask;
    private Long _value;


    Map<Class<? extends Augmentation<NxmNxNshc2>>, Augmentation<NxmNxNshc2>> augmentation = Collections.emptyMap();

    public NxmNxNshc2Builder() {
    }

    public NxmNxNshc2Builder(NxmNxNshc2 base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxmNxNshc2>>, Augmentation<NxmNxNshc2>> aug =((AugmentationHolder<NxmNxNshc2>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._mask = base.getMask();
        this._value = base.getValue();
    }


    public Long getMask() {
        return _mask;
    }
    
    public Long getValue() {
        return _value;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxmNxNshc2>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkMaskRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public NxmNxNshc2Builder setMask(final Long value) {
    if (value != null) {
        checkMaskRange(value);
        
    }
        this._mask = value;
        return this;
    }
    private static void checkValueRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", value);
    }
    
    public NxmNxNshc2Builder setValue(final Long value) {
    if (value != null) {
        checkValueRange(value);
        
    }
        this._value = value;
        return this;
    }
    
    public NxmNxNshc2Builder addAugmentation(Class<? extends Augmentation<NxmNxNshc2>> augmentationType, Augmentation<NxmNxNshc2> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxmNxNshc2Builder removeAugmentation(Class<? extends Augmentation<NxmNxNshc2>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmNxNshc2 build() {
        return new NxmNxNshc2Impl(this);
    }

    private static final class NxmNxNshc2Impl
        extends AbstractAugmentable<NxmNxNshc2>
        implements NxmNxNshc2 {
    
        private final Long _mask;
        private final Long _value;
    
        NxmNxNshc2Impl(NxmNxNshc2Builder base) {
            super(base.augmentation);
            this._mask = base.getMask();
            this._value = base.getValue();
        }
    
        @Override
        public Class<NxmNxNshc2> getImplementedInterface() {
            return NxmNxNshc2.class;
        }
    
        @Override
        public Long getMask() {
            return _mask;
        }
        
        @Override
        public Long getValue() {
            return _value;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_mask);
            result = prime * result + Objects.hashCode(_value);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxNshc2.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmNxNshc2 other = (NxmNxNshc2)obj;
            if (!Objects.equals(_mask, other.getMask())) {
                return false;
            }
            if (!Objects.equals(_value, other.getValue())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxmNxNshc2Impl otherImpl = (NxmNxNshc2Impl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxmNxNshc2>>, Augmentation<NxmNxNshc2>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmNxNshc2");
            CodeHelpers.appendValue(helper, "_mask", _mask);
            CodeHelpers.appendValue(helper, "_value", _value);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
