package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.flow.input.updated.flow.instructions.instruction.instruction.write.actions._case.write.actions.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.load.grouping.NxRegLoad;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCaseBuilder} instances.
 *
 * @see NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCaseBuilder
 *
 */
public class NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCaseBuilder implements Builder<NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase> {

    private NxRegLoad _nxRegLoad;


    Map<Class<? extends Augmentation<NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase>>, Augmentation<NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase>> augmentation = Collections.emptyMap();

    public NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCaseBuilder() {
    }
    public NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping arg) {
        this._nxRegLoad = arg.getNxRegLoad();
    }

    public NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCaseBuilder(NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase>>, Augmentation<NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase>> aug =((AugmentationHolder<NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxRegLoad = base.getNxRegLoad();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping) {
            this._nxRegLoad = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping)arg).getNxRegLoad();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegLoadGrouping]");
    }

    public NxRegLoad getNxRegLoad() {
        return _nxRegLoad;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCaseBuilder setNxRegLoad(final NxRegLoad value) {
        this._nxRegLoad = value;
        return this;
    }
    
    public NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase>> augmentationType, Augmentation<NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase build() {
        return new NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCaseImpl(this);
    }

    private static final class NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCaseImpl
        extends AbstractAugmentable<NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase>
        implements NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase {
    
        private final NxRegLoad _nxRegLoad;
    
        NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCaseImpl(NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCaseBuilder base) {
            super(base.augmentation);
            this._nxRegLoad = base.getNxRegLoad();
        }
    
        @Override
        public Class<NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase> getImplementedInterface() {
            return NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase.class;
        }
    
        @Override
        public NxRegLoad getNxRegLoad() {
            return _nxRegLoad;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxRegLoad);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase other = (NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase)obj;
            if (!Objects.equals(_nxRegLoad, other.getNxRegLoad())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCaseImpl otherImpl = (NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase>>, Augmentation<NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionRegLoadRpcUpdateFlowUpdatedWriteActionsCase");
            CodeHelpers.appendValue(helper, "_nxRegLoad", _nxRegLoad);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
