package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcNxTunIpv4SrcCaseBuilder} instances.
 *
 * @see SrcNxTunIpv4SrcCaseBuilder
 *
 */
public class SrcNxTunIpv4SrcCaseBuilder implements Builder<SrcNxTunIpv4SrcCase> {

    private Boolean _nxTunIpv4Src;


    Map<Class<? extends Augmentation<SrcNxTunIpv4SrcCase>>, Augmentation<SrcNxTunIpv4SrcCase>> augmentation = Collections.emptyMap();

    public SrcNxTunIpv4SrcCaseBuilder() {
    }
    public SrcNxTunIpv4SrcCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4SrcGrouping arg) {
        this._nxTunIpv4Src = arg.isNxTunIpv4Src();
    }

    public SrcNxTunIpv4SrcCaseBuilder(SrcNxTunIpv4SrcCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcNxTunIpv4SrcCase>>, Augmentation<SrcNxTunIpv4SrcCase>> aug =((AugmentationHolder<SrcNxTunIpv4SrcCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxTunIpv4Src = base.isNxTunIpv4Src();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4SrcGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4SrcGrouping) {
            this._nxTunIpv4Src = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4SrcGrouping)arg).isNxTunIpv4Src();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4SrcGrouping]");
    }

    public Boolean isNxTunIpv4Src() {
        return _nxTunIpv4Src;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcNxTunIpv4SrcCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxTunIpv4SrcCaseBuilder setNxTunIpv4Src(final Boolean value) {
        this._nxTunIpv4Src = value;
        return this;
    }
    
    public SrcNxTunIpv4SrcCaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxTunIpv4SrcCase>> augmentationType, Augmentation<SrcNxTunIpv4SrcCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxTunIpv4SrcCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxTunIpv4SrcCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxTunIpv4SrcCase build() {
        return new SrcNxTunIpv4SrcCaseImpl(this);
    }

    private static final class SrcNxTunIpv4SrcCaseImpl
        extends AbstractAugmentable<SrcNxTunIpv4SrcCase>
        implements SrcNxTunIpv4SrcCase {
    
        private final Boolean _nxTunIpv4Src;
    
        SrcNxTunIpv4SrcCaseImpl(SrcNxTunIpv4SrcCaseBuilder base) {
            super(base.augmentation);
            this._nxTunIpv4Src = base.isNxTunIpv4Src();
        }
    
        @Override
        public Class<SrcNxTunIpv4SrcCase> getImplementedInterface() {
            return SrcNxTunIpv4SrcCase.class;
        }
    
        @Override
        public Boolean isNxTunIpv4Src() {
            return _nxTunIpv4Src;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxTunIpv4Src);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxTunIpv4SrcCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcNxTunIpv4SrcCase other = (SrcNxTunIpv4SrcCase)obj;
            if (!Objects.equals(_nxTunIpv4Src, other.isNxTunIpv4Src())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxTunIpv4SrcCaseImpl otherImpl = (SrcNxTunIpv4SrcCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxTunIpv4SrcCase>>, Augmentation<SrcNxTunIpv4SrcCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxTunIpv4SrcCase");
            CodeHelpers.appendValue(helper, "_nxTunIpv4Src", _nxTunIpv4Src);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
