package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxReg;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcNxRegCaseBuilder} instances.
 *
 * @see SrcNxRegCaseBuilder
 *
 */
public class SrcNxRegCaseBuilder implements Builder<SrcNxRegCase> {

    private Class<? extends NxmNxReg> _nxReg;


    Map<Class<? extends Augmentation<SrcNxRegCase>>, Augmentation<SrcNxRegCase>> augmentation = Collections.emptyMap();

    public SrcNxRegCaseBuilder() {
    }
    public SrcNxRegCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxRegGrouping arg) {
        this._nxReg = arg.getNxReg();
    }

    public SrcNxRegCaseBuilder(SrcNxRegCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcNxRegCase>>, Augmentation<SrcNxRegCase>> aug =((AugmentationHolder<SrcNxRegCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxReg = base.getNxReg();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxRegGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxRegGrouping) {
            this._nxReg = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxRegGrouping)arg).getNxReg();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxRegGrouping]");
    }

    public Class<? extends NxmNxReg> getNxReg() {
        return _nxReg;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcNxRegCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxRegCaseBuilder setNxReg(final Class<? extends NxmNxReg> value) {
        this._nxReg = value;
        return this;
    }
    
    public SrcNxRegCaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxRegCase>> augmentationType, Augmentation<SrcNxRegCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxRegCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxRegCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxRegCase build() {
        return new SrcNxRegCaseImpl(this);
    }

    private static final class SrcNxRegCaseImpl
        extends AbstractAugmentable<SrcNxRegCase>
        implements SrcNxRegCase {
    
        private final Class<? extends NxmNxReg> _nxReg;
    
        SrcNxRegCaseImpl(SrcNxRegCaseBuilder base) {
            super(base.augmentation);
            this._nxReg = base.getNxReg();
        }
    
        @Override
        public Class<SrcNxRegCase> getImplementedInterface() {
            return SrcNxRegCase.class;
        }
    
        @Override
        public Class<? extends NxmNxReg> getNxReg() {
            return _nxReg;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxReg);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxRegCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcNxRegCase other = (SrcNxRegCase)obj;
            if (!Objects.equals(_nxReg, other.getNxReg())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxRegCaseImpl otherImpl = (SrcNxRegCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxRegCase>>, Augmentation<SrcNxRegCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxRegCase");
            CodeHelpers.appendValue(helper, "_nxReg", _nxReg);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
