package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcNxOfMetadataCaseBuilder} instances.
 *
 * @see SrcNxOfMetadataCaseBuilder
 *
 */
public class SrcNxOfMetadataCaseBuilder implements Builder<SrcNxOfMetadataCase> {

    private Boolean _ofMetadata;


    Map<Class<? extends Augmentation<SrcNxOfMetadataCase>>, Augmentation<SrcNxOfMetadataCase>> augmentation = Collections.emptyMap();

    public SrcNxOfMetadataCaseBuilder() {
    }
    public SrcNxOfMetadataCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMetadataGrouping arg) {
        this._ofMetadata = arg.isOfMetadata();
    }

    public SrcNxOfMetadataCaseBuilder(SrcNxOfMetadataCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcNxOfMetadataCase>>, Augmentation<SrcNxOfMetadataCase>> aug =((AugmentationHolder<SrcNxOfMetadataCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._ofMetadata = base.isOfMetadata();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMetadataGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMetadataGrouping) {
            this._ofMetadata = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMetadataGrouping)arg).isOfMetadata();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMetadataGrouping]");
    }

    public Boolean isOfMetadata() {
        return _ofMetadata;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcNxOfMetadataCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxOfMetadataCaseBuilder setOfMetadata(final Boolean value) {
        this._ofMetadata = value;
        return this;
    }
    
    public SrcNxOfMetadataCaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxOfMetadataCase>> augmentationType, Augmentation<SrcNxOfMetadataCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxOfMetadataCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxOfMetadataCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxOfMetadataCase build() {
        return new SrcNxOfMetadataCaseImpl(this);
    }

    private static final class SrcNxOfMetadataCaseImpl
        extends AbstractAugmentable<SrcNxOfMetadataCase>
        implements SrcNxOfMetadataCase {
    
        private final Boolean _ofMetadata;
    
        SrcNxOfMetadataCaseImpl(SrcNxOfMetadataCaseBuilder base) {
            super(base.augmentation);
            this._ofMetadata = base.isOfMetadata();
        }
    
        @Override
        public Class<SrcNxOfMetadataCase> getImplementedInterface() {
            return SrcNxOfMetadataCase.class;
        }
    
        @Override
        public Boolean isOfMetadata() {
            return _ofMetadata;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ofMetadata);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxOfMetadataCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcNxOfMetadataCase other = (SrcNxOfMetadataCase)obj;
            if (!Objects.equals(_ofMetadata, other.isOfMetadata())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxOfMetadataCaseImpl otherImpl = (SrcNxOfMetadataCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxOfMetadataCase>>, Augmentation<SrcNxOfMetadataCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxOfMetadataCase");
            CodeHelpers.appendValue(helper, "_ofMetadata", _ofMetadata);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
