package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcNxNspCaseBuilder} instances.
 *
 * @see SrcNxNspCaseBuilder
 *
 */
public class SrcNxNspCaseBuilder implements Builder<SrcNxNspCase> {

    private Boolean _nxNspDst;


    Map<Class<? extends Augmentation<SrcNxNspCase>>, Augmentation<SrcNxNspCase>> augmentation = Collections.emptyMap();

    public SrcNxNspCaseBuilder() {
    }
    public SrcNxNspCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNspGrouping arg) {
        this._nxNspDst = arg.isNxNspDst();
    }

    public SrcNxNspCaseBuilder(SrcNxNspCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcNxNspCase>>, Augmentation<SrcNxNspCase>> aug =((AugmentationHolder<SrcNxNspCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxNspDst = base.isNxNspDst();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNspGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNspGrouping) {
            this._nxNspDst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNspGrouping)arg).isNxNspDst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNspGrouping]");
    }

    public Boolean isNxNspDst() {
        return _nxNspDst;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcNxNspCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxNspCaseBuilder setNxNspDst(final Boolean value) {
        this._nxNspDst = value;
        return this;
    }
    
    public SrcNxNspCaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxNspCase>> augmentationType, Augmentation<SrcNxNspCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxNspCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxNspCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxNspCase build() {
        return new SrcNxNspCaseImpl(this);
    }

    private static final class SrcNxNspCaseImpl
        extends AbstractAugmentable<SrcNxNspCase>
        implements SrcNxNspCase {
    
        private final Boolean _nxNspDst;
    
        SrcNxNspCaseImpl(SrcNxNspCaseBuilder base) {
            super(base.augmentation);
            this._nxNspDst = base.isNxNspDst();
        }
    
        @Override
        public Class<SrcNxNspCase> getImplementedInterface() {
            return SrcNxNspCase.class;
        }
    
        @Override
        public Boolean isNxNspDst() {
            return _nxNspDst;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxNspDst);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxNspCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcNxNspCase other = (SrcNxNspCase)obj;
            if (!Objects.equals(_nxNspDst, other.isNxNspDst())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxNspCaseImpl otherImpl = (SrcNxNspCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxNspCase>>, Augmentation<SrcNxNspCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxNspCase");
            CodeHelpers.appendValue(helper, "_nxNspDst", _nxNspDst);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
