package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcNxNshc4CaseBuilder} instances.
 *
 * @see SrcNxNshc4CaseBuilder
 *
 */
public class SrcNxNshc4CaseBuilder implements Builder<SrcNxNshc4Case> {

    private Boolean _nxNshc4Dst;


    Map<Class<? extends Augmentation<SrcNxNshc4Case>>, Augmentation<SrcNxNshc4Case>> augmentation = Collections.emptyMap();

    public SrcNxNshc4CaseBuilder() {
    }
    public SrcNxNshc4CaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc4Grouping arg) {
        this._nxNshc4Dst = arg.isNxNshc4Dst();
    }

    public SrcNxNshc4CaseBuilder(SrcNxNshc4Case base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcNxNshc4Case>>, Augmentation<SrcNxNshc4Case>> aug =((AugmentationHolder<SrcNxNshc4Case>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxNshc4Dst = base.isNxNshc4Dst();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc4Grouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc4Grouping) {
            this._nxNshc4Dst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc4Grouping)arg).isNxNshc4Dst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshc4Grouping]");
    }

    public Boolean isNxNshc4Dst() {
        return _nxNshc4Dst;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcNxNshc4Case>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxNshc4CaseBuilder setNxNshc4Dst(final Boolean value) {
        this._nxNshc4Dst = value;
        return this;
    }
    
    public SrcNxNshc4CaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxNshc4Case>> augmentationType, Augmentation<SrcNxNshc4Case> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxNshc4CaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxNshc4Case>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxNshc4Case build() {
        return new SrcNxNshc4CaseImpl(this);
    }

    private static final class SrcNxNshc4CaseImpl
        extends AbstractAugmentable<SrcNxNshc4Case>
        implements SrcNxNshc4Case {
    
        private final Boolean _nxNshc4Dst;
    
        SrcNxNshc4CaseImpl(SrcNxNshc4CaseBuilder base) {
            super(base.augmentation);
            this._nxNshc4Dst = base.isNxNshc4Dst();
        }
    
        @Override
        public Class<SrcNxNshc4Case> getImplementedInterface() {
            return SrcNxNshc4Case.class;
        }
    
        @Override
        public Boolean isNxNshc4Dst() {
            return _nxNshc4Dst;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxNshc4Dst);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxNshc4Case.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcNxNshc4Case other = (SrcNxNshc4Case)obj;
            if (!Objects.equals(_nxNshc4Dst, other.isNxNshc4Dst())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxNshc4CaseImpl otherImpl = (SrcNxNshc4CaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxNshc4Case>>, Augmentation<SrcNxNshc4Case>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxNshc4Case");
            CodeHelpers.appendValue(helper, "_nxNshc4Dst", _nxNshc4Dst);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
