package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcNxArpThaCaseBuilder} instances.
 *
 * @see SrcNxArpThaCaseBuilder
 *
 */
public class SrcNxArpThaCaseBuilder implements Builder<SrcNxArpThaCase> {

    private Boolean _nxArpTha;


    Map<Class<? extends Augmentation<SrcNxArpThaCase>>, Augmentation<SrcNxArpThaCase>> augmentation = Collections.emptyMap();

    public SrcNxArpThaCaseBuilder() {
    }
    public SrcNxArpThaCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxArpThaGrouping arg) {
        this._nxArpTha = arg.isNxArpTha();
    }

    public SrcNxArpThaCaseBuilder(SrcNxArpThaCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcNxArpThaCase>>, Augmentation<SrcNxArpThaCase>> aug =((AugmentationHolder<SrcNxArpThaCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxArpTha = base.isNxArpTha();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxArpThaGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxArpThaGrouping) {
            this._nxArpTha = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxArpThaGrouping)arg).isNxArpTha();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxArpThaGrouping]");
    }

    public Boolean isNxArpTha() {
        return _nxArpTha;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SrcNxArpThaCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxArpThaCaseBuilder setNxArpTha(final Boolean value) {
        this._nxArpTha = value;
        return this;
    }
    
    public SrcNxArpThaCaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxArpThaCase>> augmentationType, Augmentation<SrcNxArpThaCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxArpThaCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxArpThaCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxArpThaCase build() {
        return new SrcNxArpThaCaseImpl(this);
    }

    private static final class SrcNxArpThaCaseImpl
        extends AbstractAugmentable<SrcNxArpThaCase>
        implements SrcNxArpThaCase {
    
        private final Boolean _nxArpTha;
    
        SrcNxArpThaCaseImpl(SrcNxArpThaCaseBuilder base) {
            super(base.augmentation);
            this._nxArpTha = base.isNxArpTha();
        }
    
        @Override
        public Class<SrcNxArpThaCase> getImplementedInterface() {
            return SrcNxArpThaCase.class;
        }
    
        @Override
        public Boolean isNxArpTha() {
            return _nxArpTha;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxArpTha);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxArpThaCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcNxArpThaCase other = (SrcNxArpThaCase)obj;
            if (!Objects.equals(_nxArpTha, other.isNxArpTha())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxArpThaCaseImpl otherImpl = (SrcNxArpThaCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxArpThaCase>>, Augmentation<SrcNxArpThaCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxArpThaCase");
            CodeHelpers.appendValue(helper, "_nxArpTha", _nxArpTha);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
