package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.nx.learn;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.FlowModSpec;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlowModsBuilder} instances.
 *
 * @see FlowModsBuilder
 *
 */
public class FlowModsBuilder implements Builder<FlowMods> {

    private FlowModSpec _flowModSpec;


    Map<Class<? extends Augmentation<FlowMods>>, Augmentation<FlowMods>> augmentation = Collections.emptyMap();

    public FlowModsBuilder() {
    }
    public FlowModsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.FlowModSpec arg) {
        this._flowModSpec = arg.getFlowModSpec();
    }

    public FlowModsBuilder(FlowMods base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<FlowMods>>, Augmentation<FlowMods>> aug =((AugmentationHolder<FlowMods>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._flowModSpec = base.getFlowModSpec();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.FlowModSpec</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.FlowModSpec) {
            this._flowModSpec = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.FlowModSpec)arg).getFlowModSpec();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.FlowModSpec]");
    }

    public FlowModSpec getFlowModSpec() {
        return _flowModSpec;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowMods>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public FlowModsBuilder setFlowModSpec(final FlowModSpec value) {
        this._flowModSpec = value;
        return this;
    }
    
    public FlowModsBuilder addAugmentation(Class<? extends Augmentation<FlowMods>> augmentationType, Augmentation<FlowMods> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowModsBuilder removeAugmentation(Class<? extends Augmentation<FlowMods>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowMods build() {
        return new FlowModsImpl(this);
    }

    private static final class FlowModsImpl
        extends AbstractAugmentable<FlowMods>
        implements FlowMods {
    
        private final FlowModSpec _flowModSpec;
    
        FlowModsImpl(FlowModsBuilder base) {
            super(base.augmentation);
            this._flowModSpec = base.getFlowModSpec();
        }
    
        @Override
        public Class<FlowMods> getImplementedInterface() {
            return FlowMods.class;
        }
    
        @Override
        public FlowModSpec getFlowModSpec() {
            return _flowModSpec;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flowModSpec);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowMods.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlowMods other = (FlowMods)obj;
            if (!Objects.equals(_flowModSpec, other.getFlowModSpec())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowModsImpl otherImpl = (FlowModsImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowMods>>, Augmentation<FlowMods>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowMods");
            CodeHelpers.appendValue(helper, "_flowModSpec", _flowModSpec);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
