package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nodes.node.table.flow.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.fin.timeout.grouping.NxActionFinTimeout;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionFinTimeoutNodesNodeTableFlowApplyActionsCaseBuilder} instances.
 *
 * @see NxActionFinTimeoutNodesNodeTableFlowApplyActionsCaseBuilder
 *
 */
public class NxActionFinTimeoutNodesNodeTableFlowApplyActionsCaseBuilder implements Builder<NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase> {

    private NxActionFinTimeout _nxActionFinTimeout;


    Map<Class<? extends Augmentation<NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase>>, Augmentation<NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase>> augmentation = Collections.emptyMap();

    public NxActionFinTimeoutNodesNodeTableFlowApplyActionsCaseBuilder() {
    }
    public NxActionFinTimeoutNodesNodeTableFlowApplyActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping arg) {
        this._nxActionFinTimeout = arg.getNxActionFinTimeout();
    }

    public NxActionFinTimeoutNodesNodeTableFlowApplyActionsCaseBuilder(NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase>>, Augmentation<NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase>> aug =((AugmentationHolder<NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxActionFinTimeout = base.getNxActionFinTimeout();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping) {
            this._nxActionFinTimeout = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping)arg).getNxActionFinTimeout();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping]");
    }

    public NxActionFinTimeout getNxActionFinTimeout() {
        return _nxActionFinTimeout;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionFinTimeoutNodesNodeTableFlowApplyActionsCaseBuilder setNxActionFinTimeout(final NxActionFinTimeout value) {
        this._nxActionFinTimeout = value;
        return this;
    }
    
    public NxActionFinTimeoutNodesNodeTableFlowApplyActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase>> augmentationType, Augmentation<NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionFinTimeoutNodesNodeTableFlowApplyActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase build() {
        return new NxActionFinTimeoutNodesNodeTableFlowApplyActionsCaseImpl(this);
    }

    private static final class NxActionFinTimeoutNodesNodeTableFlowApplyActionsCaseImpl
        extends AbstractAugmentable<NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase>
        implements NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase {
    
        private final NxActionFinTimeout _nxActionFinTimeout;
    
        NxActionFinTimeoutNodesNodeTableFlowApplyActionsCaseImpl(NxActionFinTimeoutNodesNodeTableFlowApplyActionsCaseBuilder base) {
            super(base.augmentation);
            this._nxActionFinTimeout = base.getNxActionFinTimeout();
        }
    
        @Override
        public Class<NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase> getImplementedInterface() {
            return NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase.class;
        }
    
        @Override
        public NxActionFinTimeout getNxActionFinTimeout() {
            return _nxActionFinTimeout;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxActionFinTimeout);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase other = (NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase)obj;
            if (!Objects.equals(_nxActionFinTimeout, other.getNxActionFinTimeout())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionFinTimeoutNodesNodeTableFlowApplyActionsCaseImpl otherImpl = (NxActionFinTimeoutNodesNodeTableFlowApplyActionsCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase>>, Augmentation<NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionFinTimeoutNodesNodeTableFlowApplyActionsCase");
            CodeHelpers.appendValue(helper, "_nxActionFinTimeout", _nxActionFinTimeout);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
