package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nodes.node.table.flow.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.ct.clear.grouping.NxCtClear;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionCtClearNodesNodeTableFlowApplyActionsCaseBuilder} instances.
 *
 * @see NxActionCtClearNodesNodeTableFlowApplyActionsCaseBuilder
 *
 */
public class NxActionCtClearNodesNodeTableFlowApplyActionsCaseBuilder implements Builder<NxActionCtClearNodesNodeTableFlowApplyActionsCase> {

    private NxCtClear _nxCtClear;


    Map<Class<? extends Augmentation<NxActionCtClearNodesNodeTableFlowApplyActionsCase>>, Augmentation<NxActionCtClearNodesNodeTableFlowApplyActionsCase>> augmentation = Collections.emptyMap();

    public NxActionCtClearNodesNodeTableFlowApplyActionsCaseBuilder() {
    }
    public NxActionCtClearNodesNodeTableFlowApplyActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping arg) {
        this._nxCtClear = arg.getNxCtClear();
    }

    public NxActionCtClearNodesNodeTableFlowApplyActionsCaseBuilder(NxActionCtClearNodesNodeTableFlowApplyActionsCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionCtClearNodesNodeTableFlowApplyActionsCase>>, Augmentation<NxActionCtClearNodesNodeTableFlowApplyActionsCase>> aug =((AugmentationHolder<NxActionCtClearNodesNodeTableFlowApplyActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxCtClear = base.getNxCtClear();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping) {
            this._nxCtClear = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping)arg).getNxCtClear();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping]");
    }

    public NxCtClear getNxCtClear() {
        return _nxCtClear;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionCtClearNodesNodeTableFlowApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionCtClearNodesNodeTableFlowApplyActionsCaseBuilder setNxCtClear(final NxCtClear value) {
        this._nxCtClear = value;
        return this;
    }
    
    public NxActionCtClearNodesNodeTableFlowApplyActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionCtClearNodesNodeTableFlowApplyActionsCase>> augmentationType, Augmentation<NxActionCtClearNodesNodeTableFlowApplyActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionCtClearNodesNodeTableFlowApplyActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionCtClearNodesNodeTableFlowApplyActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionCtClearNodesNodeTableFlowApplyActionsCase build() {
        return new NxActionCtClearNodesNodeTableFlowApplyActionsCaseImpl(this);
    }

    private static final class NxActionCtClearNodesNodeTableFlowApplyActionsCaseImpl
        extends AbstractAugmentable<NxActionCtClearNodesNodeTableFlowApplyActionsCase>
        implements NxActionCtClearNodesNodeTableFlowApplyActionsCase {
    
        private final NxCtClear _nxCtClear;
    
        NxActionCtClearNodesNodeTableFlowApplyActionsCaseImpl(NxActionCtClearNodesNodeTableFlowApplyActionsCaseBuilder base) {
            super(base.augmentation);
            this._nxCtClear = base.getNxCtClear();
        }
    
        @Override
        public Class<NxActionCtClearNodesNodeTableFlowApplyActionsCase> getImplementedInterface() {
            return NxActionCtClearNodesNodeTableFlowApplyActionsCase.class;
        }
    
        @Override
        public NxCtClear getNxCtClear() {
            return _nxCtClear;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxCtClear);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionCtClearNodesNodeTableFlowApplyActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionCtClearNodesNodeTableFlowApplyActionsCase other = (NxActionCtClearNodesNodeTableFlowApplyActionsCase)obj;
            if (!Objects.equals(_nxCtClear, other.getNxCtClear())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionCtClearNodesNodeTableFlowApplyActionsCaseImpl otherImpl = (NxActionCtClearNodesNodeTableFlowApplyActionsCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionCtClearNodesNodeTableFlowApplyActionsCase>>, Augmentation<NxActionCtClearNodesNodeTableFlowApplyActionsCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionCtClearNodesNodeTableFlowApplyActionsCase");
            CodeHelpers.appendValue(helper, "_nxCtClear", _nxCtClear);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
