package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.copy.value.into.field._case.FlowModCopyValueIntoField;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlowModCopyValueIntoFieldCaseBuilder} instances.
 *
 * @see FlowModCopyValueIntoFieldCaseBuilder
 *
 */
public class FlowModCopyValueIntoFieldCaseBuilder implements Builder<FlowModCopyValueIntoFieldCase> {

    private FlowModCopyValueIntoField _flowModCopyValueIntoField;


    Map<Class<? extends Augmentation<FlowModCopyValueIntoFieldCase>>, Augmentation<FlowModCopyValueIntoFieldCase>> augmentation = Collections.emptyMap();

    public FlowModCopyValueIntoFieldCaseBuilder() {
    }

    public FlowModCopyValueIntoFieldCaseBuilder(FlowModCopyValueIntoFieldCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<FlowModCopyValueIntoFieldCase>>, Augmentation<FlowModCopyValueIntoFieldCase>> aug =((AugmentationHolder<FlowModCopyValueIntoFieldCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._flowModCopyValueIntoField = base.getFlowModCopyValueIntoField();
    }


    public FlowModCopyValueIntoField getFlowModCopyValueIntoField() {
        return _flowModCopyValueIntoField;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowModCopyValueIntoFieldCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public FlowModCopyValueIntoFieldCaseBuilder setFlowModCopyValueIntoField(final FlowModCopyValueIntoField value) {
        this._flowModCopyValueIntoField = value;
        return this;
    }
    
    public FlowModCopyValueIntoFieldCaseBuilder addAugmentation(Class<? extends Augmentation<FlowModCopyValueIntoFieldCase>> augmentationType, Augmentation<FlowModCopyValueIntoFieldCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlowModCopyValueIntoFieldCaseBuilder removeAugmentation(Class<? extends Augmentation<FlowModCopyValueIntoFieldCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowModCopyValueIntoFieldCase build() {
        return new FlowModCopyValueIntoFieldCaseImpl(this);
    }

    private static final class FlowModCopyValueIntoFieldCaseImpl
        extends AbstractAugmentable<FlowModCopyValueIntoFieldCase>
        implements FlowModCopyValueIntoFieldCase {
    
        private final FlowModCopyValueIntoField _flowModCopyValueIntoField;
    
        FlowModCopyValueIntoFieldCaseImpl(FlowModCopyValueIntoFieldCaseBuilder base) {
            super(base.augmentation);
            this._flowModCopyValueIntoField = base.getFlowModCopyValueIntoField();
        }
    
        @Override
        public Class<FlowModCopyValueIntoFieldCase> getImplementedInterface() {
            return FlowModCopyValueIntoFieldCase.class;
        }
    
        @Override
        public FlowModCopyValueIntoField getFlowModCopyValueIntoField() {
            return _flowModCopyValueIntoField;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flowModCopyValueIntoField);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowModCopyValueIntoFieldCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlowModCopyValueIntoFieldCase other = (FlowModCopyValueIntoFieldCase)obj;
            if (!Objects.equals(_flowModCopyValueIntoField, other.getFlowModCopyValueIntoField())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlowModCopyValueIntoFieldCaseImpl otherImpl = (FlowModCopyValueIntoFieldCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlowModCopyValueIntoFieldCase>>, Augmentation<FlowModCopyValueIntoFieldCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlowModCopyValueIntoFieldCase");
            CodeHelpers.appendValue(helper, "_flowModCopyValueIntoField", _flowModCopyValueIntoField);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
