package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DstNxNshTtlCaseBuilder} instances.
 *
 * @see DstNxNshTtlCaseBuilder
 *
 */
public class DstNxNshTtlCaseBuilder implements Builder<DstNxNshTtlCase> {

    private Boolean _nxNshTtl;


    Map<Class<? extends Augmentation<DstNxNshTtlCase>>, Augmentation<DstNxNshTtlCase>> augmentation = Collections.emptyMap();

    public DstNxNshTtlCaseBuilder() {
    }
    public DstNxNshTtlCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshTtlGrouping arg) {
        this._nxNshTtl = arg.isNxNshTtl();
    }

    public DstNxNshTtlCaseBuilder(DstNxNshTtlCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DstNxNshTtlCase>>, Augmentation<DstNxNshTtlCase>> aug =((AugmentationHolder<DstNxNshTtlCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxNshTtl = base.isNxNshTtl();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshTtlGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshTtlGrouping) {
            this._nxNshTtl = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshTtlGrouping)arg).isNxNshTtl();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshTtlGrouping]");
    }

    public Boolean isNxNshTtl() {
        return _nxNshTtl;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DstNxNshTtlCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstNxNshTtlCaseBuilder setNxNshTtl(final Boolean value) {
        this._nxNshTtl = value;
        return this;
    }
    
    public DstNxNshTtlCaseBuilder addAugmentation(Class<? extends Augmentation<DstNxNshTtlCase>> augmentationType, Augmentation<DstNxNshTtlCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstNxNshTtlCaseBuilder removeAugmentation(Class<? extends Augmentation<DstNxNshTtlCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstNxNshTtlCase build() {
        return new DstNxNshTtlCaseImpl(this);
    }

    private static final class DstNxNshTtlCaseImpl
        extends AbstractAugmentable<DstNxNshTtlCase>
        implements DstNxNshTtlCase {
    
        private final Boolean _nxNshTtl;
    
        DstNxNshTtlCaseImpl(DstNxNshTtlCaseBuilder base) {
            super(base.augmentation);
            this._nxNshTtl = base.isNxNshTtl();
        }
    
        @Override
        public Class<DstNxNshTtlCase> getImplementedInterface() {
            return DstNxNshTtlCase.class;
        }
    
        @Override
        public Boolean isNxNshTtl() {
            return _nxNshTtl;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxNshTtl);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstNxNshTtlCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DstNxNshTtlCase other = (DstNxNshTtlCase)obj;
            if (!Objects.equals(_nxNshTtl, other.isNxNshTtl())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstNxNshTtlCaseImpl otherImpl = (DstNxNshTtlCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstNxNshTtlCase>>, Augmentation<DstNxNshTtlCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstNxNshTtlCase");
            CodeHelpers.appendValue(helper, "_nxNshTtl", _nxNshTtl);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
