package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DstNxNshFlagsCaseBuilder} instances.
 *
 * @see DstNxNshFlagsCaseBuilder
 *
 */
public class DstNxNshFlagsCaseBuilder implements Builder<DstNxNshFlagsCase> {

    private Boolean _nxNshFlags;


    Map<Class<? extends Augmentation<DstNxNshFlagsCase>>, Augmentation<DstNxNshFlagsCase>> augmentation = Collections.emptyMap();

    public DstNxNshFlagsCaseBuilder() {
    }
    public DstNxNshFlagsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshFlagsGrouping arg) {
        this._nxNshFlags = arg.isNxNshFlags();
    }

    public DstNxNshFlagsCaseBuilder(DstNxNshFlagsCase base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DstNxNshFlagsCase>>, Augmentation<DstNxNshFlagsCase>> aug =((AugmentationHolder<DstNxNshFlagsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._nxNshFlags = base.isNxNshFlags();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshFlagsGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshFlagsGrouping) {
            this._nxNshFlags = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshFlagsGrouping)arg).isNxNshFlags();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNshFlagsGrouping]");
    }

    public Boolean isNxNshFlags() {
        return _nxNshFlags;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DstNxNshFlagsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstNxNshFlagsCaseBuilder setNxNshFlags(final Boolean value) {
        this._nxNshFlags = value;
        return this;
    }
    
    public DstNxNshFlagsCaseBuilder addAugmentation(Class<? extends Augmentation<DstNxNshFlagsCase>> augmentationType, Augmentation<DstNxNshFlagsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstNxNshFlagsCaseBuilder removeAugmentation(Class<? extends Augmentation<DstNxNshFlagsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstNxNshFlagsCase build() {
        return new DstNxNshFlagsCaseImpl(this);
    }

    private static final class DstNxNshFlagsCaseImpl
        extends AbstractAugmentable<DstNxNshFlagsCase>
        implements DstNxNshFlagsCase {
    
        private final Boolean _nxNshFlags;
    
        DstNxNshFlagsCaseImpl(DstNxNshFlagsCaseBuilder base) {
            super(base.augmentation);
            this._nxNshFlags = base.isNxNshFlags();
        }
    
        @Override
        public Class<DstNxNshFlagsCase> getImplementedInterface() {
            return DstNxNshFlagsCase.class;
        }
    
        @Override
        public Boolean isNxNshFlags() {
            return _nxNshFlags;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxNshFlags);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstNxNshFlagsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DstNxNshFlagsCase other = (DstNxNshFlagsCase)obj;
            if (!Objects.equals(_nxNshFlags, other.isNxNshFlags())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstNxNshFlagsCaseImpl otherImpl = (DstNxNshFlagsCaseImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstNxNshFlagsCase>>, Augmentation<DstNxNshFlagsCase>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstNxNshFlagsCase");
            CodeHelpers.appendValue(helper, "_nxNshFlags", _nxNshFlags);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
