/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.tp.src.grouping;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.tp.src.grouping.NxmNxCtTpSrc;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxmNxCtTpSrcBuilder
implements Builder<NxmNxCtTpSrc> {
    private Integer _ctTpSrc;
    private Integer _mask;
    Map<Class<? extends Augmentation<NxmNxCtTpSrc>>, Augmentation<NxmNxCtTpSrc>> augmentation = Collections.emptyMap();

    public NxmNxCtTpSrcBuilder() {
    }

    public NxmNxCtTpSrcBuilder(NxmNxCtTpSrc base) {
        Map aug;
        this._ctTpSrc = base.getCtTpSrc();
        this._mask = base.getMask();
        if (base instanceof NxmNxCtTpSrcImpl) {
            NxmNxCtTpSrcImpl impl = (NxmNxCtTpSrcImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxCtTpSrc>>, Augmentation<NxmNxCtTpSrc>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxCtTpSrc>>, Augmentation<NxmNxCtTpSrc>>(aug);
        }
    }

    public Integer getCtTpSrc() {
        return this._ctTpSrc;
    }

    public Integer getMask() {
        return this._mask;
    }

    public <E extends Augmentation<NxmNxCtTpSrc>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkCtTpSrcRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public NxmNxCtTpSrcBuilder setCtTpSrc(Integer value) {
        if (value != null) {
            NxmNxCtTpSrcBuilder.checkCtTpSrcRange(value);
        }
        this._ctTpSrc = value;
        return this;
    }

    private static void checkMaskRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public NxmNxCtTpSrcBuilder setMask(Integer value) {
        if (value != null) {
            NxmNxCtTpSrcBuilder.checkMaskRange(value);
        }
        this._mask = value;
        return this;
    }

    public NxmNxCtTpSrcBuilder addAugmentation(Class<? extends Augmentation<NxmNxCtTpSrc>> augmentationType, Augmentation<NxmNxCtTpSrc> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxCtTpSrc>>, Augmentation<NxmNxCtTpSrc>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NxmNxCtTpSrcBuilder removeAugmentation(Class<? extends Augmentation<NxmNxCtTpSrc>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxmNxCtTpSrc build() {
        return new NxmNxCtTpSrcImpl(this);
    }

    private static final class NxmNxCtTpSrcImpl
    implements NxmNxCtTpSrc {
        private final Integer _ctTpSrc;
        private final Integer _mask;
        private Map<Class<? extends Augmentation<NxmNxCtTpSrc>>, Augmentation<NxmNxCtTpSrc>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NxmNxCtTpSrcImpl(NxmNxCtTpSrcBuilder base) {
            this._ctTpSrc = base.getCtTpSrc();
            this._mask = base.getMask();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<NxmNxCtTpSrc> getImplementedInterface() {
            return NxmNxCtTpSrc.class;
        }

        @Override
        public Integer getCtTpSrc() {
            return this._ctTpSrc;
        }

        @Override
        public Integer getMask() {
            return this._mask;
        }

        public <E extends Augmentation<NxmNxCtTpSrc>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ctTpSrc);
            result = 31 * result + Objects.hashCode(this._mask);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxCtTpSrc.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmNxCtTpSrc other = (NxmNxCtTpSrc)obj;
            if (!Objects.equals(this._ctTpSrc, other.getCtTpSrc())) {
                return false;
            }
            if (!Objects.equals(this._mask, other.getMask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxmNxCtTpSrcImpl otherImpl = (NxmNxCtTpSrcImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxmNxCtTpSrc>>, Augmentation<NxmNxCtTpSrc>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NxmNxCtTpSrc");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ctTpSrc", (Object)this._ctTpSrc);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_mask", (Object)this._mask);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

