package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.tun.ipv4.src.grouping;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxmNxTunIpv4SrcBuilder} instances.
 *
 * @see NxmNxTunIpv4SrcBuilder
 *
 */
public class NxmNxTunIpv4SrcBuilder implements Builder<NxmNxTunIpv4Src> {

    private Ipv4Address _ipv4Address;


    Map<Class<? extends Augmentation<NxmNxTunIpv4Src>>, Augmentation<NxmNxTunIpv4Src>> augmentation = Collections.emptyMap();

    public NxmNxTunIpv4SrcBuilder() {
    }
    public NxmNxTunIpv4SrcBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.Ipv4AddressGrouping arg) {
        this._ipv4Address = arg.getIpv4Address();
    }

    public NxmNxTunIpv4SrcBuilder(NxmNxTunIpv4Src base) {
        this._ipv4Address = base.getIpv4Address();
        if (base instanceof NxmNxTunIpv4SrcImpl) {
            NxmNxTunIpv4SrcImpl impl = (NxmNxTunIpv4SrcImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxmNxTunIpv4Src>>, Augmentation<NxmNxTunIpv4Src>> aug =((AugmentationHolder<NxmNxTunIpv4Src>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.Ipv4AddressGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.Ipv4AddressGrouping) {
            this._ipv4Address = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.Ipv4AddressGrouping)arg).getIpv4Address();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.Ipv4AddressGrouping]");
    }

    public Ipv4Address getIpv4Address() {
        return _ipv4Address;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxmNxTunIpv4Src>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxmNxTunIpv4SrcBuilder setIpv4Address(final Ipv4Address value) {
        this._ipv4Address = value;
        return this;
    }
    
    public NxmNxTunIpv4SrcBuilder addAugmentation(Class<? extends Augmentation<NxmNxTunIpv4Src>> augmentationType, Augmentation<NxmNxTunIpv4Src> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxmNxTunIpv4SrcBuilder removeAugmentation(Class<? extends Augmentation<NxmNxTunIpv4Src>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmNxTunIpv4Src build() {
        return new NxmNxTunIpv4SrcImpl(this);
    }

    private static final class NxmNxTunIpv4SrcImpl implements NxmNxTunIpv4Src {
    
        private final Ipv4Address _ipv4Address;
    
        private Map<Class<? extends Augmentation<NxmNxTunIpv4Src>>, Augmentation<NxmNxTunIpv4Src>> augmentation = Collections.emptyMap();
    
        NxmNxTunIpv4SrcImpl(NxmNxTunIpv4SrcBuilder base) {
            this._ipv4Address = base.getIpv4Address();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxmNxTunIpv4Src> getImplementedInterface() {
            return NxmNxTunIpv4Src.class;
        }
    
        @Override
        public Ipv4Address getIpv4Address() {
            return _ipv4Address;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxmNxTunIpv4Src>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ipv4Address);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxTunIpv4Src.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmNxTunIpv4Src other = (NxmNxTunIpv4Src)obj;
            if (!Objects.equals(_ipv4Address, other.getIpv4Address())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxmNxTunIpv4SrcImpl otherImpl = (NxmNxTunIpv4SrcImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxmNxTunIpv4Src>>, Augmentation<NxmNxTunIpv4Src>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmNxTunIpv4Src");
            CodeHelpers.appendValue(helper, "_ipv4Address", _ipv4Address);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
