package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsh.ttl.grouping;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxmNxNshTtlBuilder} instances.
 *
 * @see NxmNxNshTtlBuilder
 *
 */
public class NxmNxNshTtlBuilder implements Builder<NxmNxNshTtl> {

    private Short _nshTtl;


    Map<Class<? extends Augmentation<NxmNxNshTtl>>, Augmentation<NxmNxNshTtl>> augmentation = Collections.emptyMap();

    public NxmNxNshTtlBuilder() {
    }

    public NxmNxNshTtlBuilder(NxmNxNshTtl base) {
        this._nshTtl = base.getNshTtl();
        if (base instanceof NxmNxNshTtlImpl) {
            NxmNxNshTtlImpl impl = (NxmNxNshTtlImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxmNxNshTtl>>, Augmentation<NxmNxNshTtl>> aug =((AugmentationHolder<NxmNxNshTtl>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public Short getNshTtl() {
        return _nshTtl;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxmNxNshTtl>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkNshTtlRange(final short value) {
        if (value >= (short)0 && value <= (short)255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", value);
    }
    
    public NxmNxNshTtlBuilder setNshTtl(final Short value) {
    if (value != null) {
        checkNshTtlRange(value);
        
    }
        this._nshTtl = value;
        return this;
    }
    
    public NxmNxNshTtlBuilder addAugmentation(Class<? extends Augmentation<NxmNxNshTtl>> augmentationType, Augmentation<NxmNxNshTtl> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxmNxNshTtlBuilder removeAugmentation(Class<? extends Augmentation<NxmNxNshTtl>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmNxNshTtl build() {
        return new NxmNxNshTtlImpl(this);
    }

    private static final class NxmNxNshTtlImpl implements NxmNxNshTtl {
    
        private final Short _nshTtl;
    
        private Map<Class<? extends Augmentation<NxmNxNshTtl>>, Augmentation<NxmNxNshTtl>> augmentation = Collections.emptyMap();
    
        NxmNxNshTtlImpl(NxmNxNshTtlBuilder base) {
            this._nshTtl = base.getNshTtl();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxmNxNshTtl> getImplementedInterface() {
            return NxmNxNshTtl.class;
        }
    
        @Override
        public Short getNshTtl() {
            return _nshTtl;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxmNxNshTtl>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nshTtl);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxNshTtl.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmNxNshTtl other = (NxmNxNshTtl)obj;
            if (!Objects.equals(_nshTtl, other.getNshTtl())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxmNxNshTtlImpl otherImpl = (NxmNxNshTtlImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxmNxNshTtl>>, Augmentation<NxmNxNshTtl>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmNxNshTtl");
            CodeHelpers.appendValue(helper, "_nshTtl", _nshTtl);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
