package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.group.input.original.group.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.NxOutputReg;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionOutputRegRpcUpdateGroupOriginalCaseBuilder} instances.
 *
 * @see NxActionOutputRegRpcUpdateGroupOriginalCaseBuilder
 *
 */
public class NxActionOutputRegRpcUpdateGroupOriginalCaseBuilder implements Builder<NxActionOutputRegRpcUpdateGroupOriginalCase> {

    private NxOutputReg _nxOutputReg;


    Map<Class<? extends Augmentation<NxActionOutputRegRpcUpdateGroupOriginalCase>>, Augmentation<NxActionOutputRegRpcUpdateGroupOriginalCase>> augmentation = Collections.emptyMap();

    public NxActionOutputRegRpcUpdateGroupOriginalCaseBuilder() {
    }
    public NxActionOutputRegRpcUpdateGroupOriginalCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping arg) {
        this._nxOutputReg = arg.getNxOutputReg();
    }

    public NxActionOutputRegRpcUpdateGroupOriginalCaseBuilder(NxActionOutputRegRpcUpdateGroupOriginalCase base) {
        this._nxOutputReg = base.getNxOutputReg();
        if (base instanceof NxActionOutputRegRpcUpdateGroupOriginalCaseImpl) {
            NxActionOutputRegRpcUpdateGroupOriginalCaseImpl impl = (NxActionOutputRegRpcUpdateGroupOriginalCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionOutputRegRpcUpdateGroupOriginalCase>>, Augmentation<NxActionOutputRegRpcUpdateGroupOriginalCase>> aug =((AugmentationHolder<NxActionOutputRegRpcUpdateGroupOriginalCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping) {
            this._nxOutputReg = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping)arg).getNxOutputReg();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping]");
    }

    public NxOutputReg getNxOutputReg() {
        return _nxOutputReg;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxActionOutputRegRpcUpdateGroupOriginalCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionOutputRegRpcUpdateGroupOriginalCaseBuilder setNxOutputReg(final NxOutputReg value) {
        this._nxOutputReg = value;
        return this;
    }
    
    public NxActionOutputRegRpcUpdateGroupOriginalCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionOutputRegRpcUpdateGroupOriginalCase>> augmentationType, Augmentation<NxActionOutputRegRpcUpdateGroupOriginalCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionOutputRegRpcUpdateGroupOriginalCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionOutputRegRpcUpdateGroupOriginalCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionOutputRegRpcUpdateGroupOriginalCase build() {
        return new NxActionOutputRegRpcUpdateGroupOriginalCaseImpl(this);
    }

    private static final class NxActionOutputRegRpcUpdateGroupOriginalCaseImpl implements NxActionOutputRegRpcUpdateGroupOriginalCase {
    
        private final NxOutputReg _nxOutputReg;
    
        private Map<Class<? extends Augmentation<NxActionOutputRegRpcUpdateGroupOriginalCase>>, Augmentation<NxActionOutputRegRpcUpdateGroupOriginalCase>> augmentation = Collections.emptyMap();
    
        NxActionOutputRegRpcUpdateGroupOriginalCaseImpl(NxActionOutputRegRpcUpdateGroupOriginalCaseBuilder base) {
            this._nxOutputReg = base.getNxOutputReg();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionOutputRegRpcUpdateGroupOriginalCase> getImplementedInterface() {
            return NxActionOutputRegRpcUpdateGroupOriginalCase.class;
        }
    
        @Override
        public NxOutputReg getNxOutputReg() {
            return _nxOutputReg;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxActionOutputRegRpcUpdateGroupOriginalCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxOutputReg);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionOutputRegRpcUpdateGroupOriginalCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionOutputRegRpcUpdateGroupOriginalCase other = (NxActionOutputRegRpcUpdateGroupOriginalCase)obj;
            if (!Objects.equals(_nxOutputReg, other.getNxOutputReg())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionOutputRegRpcUpdateGroupOriginalCaseImpl otherImpl = (NxActionOutputRegRpcUpdateGroupOriginalCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionOutputRegRpcUpdateGroupOriginalCase>>, Augmentation<NxActionOutputRegRpcUpdateGroupOriginalCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionOutputRegRpcUpdateGroupOriginalCase");
            CodeHelpers.appendValue(helper, "_nxOutputReg", _nxOutputReg);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
