package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.group.input.original.group.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionMultipathRpcUpdateGroupOriginalCaseBuilder} instances.
 *
 * @see NxActionMultipathRpcUpdateGroupOriginalCaseBuilder
 *
 */
public class NxActionMultipathRpcUpdateGroupOriginalCaseBuilder implements Builder<NxActionMultipathRpcUpdateGroupOriginalCase> {

    private NxMultipath _nxMultipath;


    Map<Class<? extends Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase>>, Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase>> augmentation = Collections.emptyMap();

    public NxActionMultipathRpcUpdateGroupOriginalCaseBuilder() {
    }
    public NxActionMultipathRpcUpdateGroupOriginalCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping arg) {
        this._nxMultipath = arg.getNxMultipath();
    }

    public NxActionMultipathRpcUpdateGroupOriginalCaseBuilder(NxActionMultipathRpcUpdateGroupOriginalCase base) {
        this._nxMultipath = base.getNxMultipath();
        if (base instanceof NxActionMultipathRpcUpdateGroupOriginalCaseImpl) {
            NxActionMultipathRpcUpdateGroupOriginalCaseImpl impl = (NxActionMultipathRpcUpdateGroupOriginalCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase>>, Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase>> aug =((AugmentationHolder<NxActionMultipathRpcUpdateGroupOriginalCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping) {
            this._nxMultipath = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping)arg).getNxMultipath();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping]");
    }

    public NxMultipath getNxMultipath() {
        return _nxMultipath;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionMultipathRpcUpdateGroupOriginalCaseBuilder setNxMultipath(final NxMultipath value) {
        this._nxMultipath = value;
        return this;
    }
    
    public NxActionMultipathRpcUpdateGroupOriginalCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase>> augmentationType, Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionMultipathRpcUpdateGroupOriginalCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionMultipathRpcUpdateGroupOriginalCase build() {
        return new NxActionMultipathRpcUpdateGroupOriginalCaseImpl(this);
    }

    private static final class NxActionMultipathRpcUpdateGroupOriginalCaseImpl implements NxActionMultipathRpcUpdateGroupOriginalCase {
    
        private final NxMultipath _nxMultipath;
    
        private Map<Class<? extends Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase>>, Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase>> augmentation = Collections.emptyMap();
    
        NxActionMultipathRpcUpdateGroupOriginalCaseImpl(NxActionMultipathRpcUpdateGroupOriginalCaseBuilder base) {
            this._nxMultipath = base.getNxMultipath();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionMultipathRpcUpdateGroupOriginalCase> getImplementedInterface() {
            return NxActionMultipathRpcUpdateGroupOriginalCase.class;
        }
    
        @Override
        public NxMultipath getNxMultipath() {
            return _nxMultipath;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxMultipath);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionMultipathRpcUpdateGroupOriginalCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionMultipathRpcUpdateGroupOriginalCase other = (NxActionMultipathRpcUpdateGroupOriginalCase)obj;
            if (!Objects.equals(_nxMultipath, other.getNxMultipath())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionMultipathRpcUpdateGroupOriginalCaseImpl otherImpl = (NxActionMultipathRpcUpdateGroupOriginalCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase>>, Augmentation<NxActionMultipathRpcUpdateGroupOriginalCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionMultipathRpcUpdateGroupOriginalCase");
            CodeHelpers.appendValue(helper, "_nxMultipath", _nxMultipath);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
