package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcOfArpSpaCaseBuilder} instances.
 *
 * @see SrcOfArpSpaCaseBuilder
 *
 */
public class SrcOfArpSpaCaseBuilder implements Builder<SrcOfArpSpaCase> {

    private Boolean _ofArpSpa;


    Map<Class<? extends Augmentation<SrcOfArpSpaCase>>, Augmentation<SrcOfArpSpaCase>> augmentation = Collections.emptyMap();

    public SrcOfArpSpaCaseBuilder() {
    }
    public SrcOfArpSpaCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfArpSpaGrouping arg) {
        this._ofArpSpa = arg.isOfArpSpa();
    }

    public SrcOfArpSpaCaseBuilder(SrcOfArpSpaCase base) {
        this._ofArpSpa = base.isOfArpSpa();
        if (base instanceof SrcOfArpSpaCaseImpl) {
            SrcOfArpSpaCaseImpl impl = (SrcOfArpSpaCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcOfArpSpaCase>>, Augmentation<SrcOfArpSpaCase>> aug =((AugmentationHolder<SrcOfArpSpaCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfArpSpaGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfArpSpaGrouping) {
            this._ofArpSpa = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfArpSpaGrouping)arg).isOfArpSpa();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmOfArpSpaGrouping]");
    }

    public Boolean isOfArpSpa() {
        return _ofArpSpa;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<SrcOfArpSpaCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcOfArpSpaCaseBuilder setOfArpSpa(final Boolean value) {
        this._ofArpSpa = value;
        return this;
    }
    
    public SrcOfArpSpaCaseBuilder addAugmentation(Class<? extends Augmentation<SrcOfArpSpaCase>> augmentationType, Augmentation<SrcOfArpSpaCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcOfArpSpaCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcOfArpSpaCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcOfArpSpaCase build() {
        return new SrcOfArpSpaCaseImpl(this);
    }

    private static final class SrcOfArpSpaCaseImpl implements SrcOfArpSpaCase {
    
        private final Boolean _ofArpSpa;
    
        private Map<Class<? extends Augmentation<SrcOfArpSpaCase>>, Augmentation<SrcOfArpSpaCase>> augmentation = Collections.emptyMap();
    
        SrcOfArpSpaCaseImpl(SrcOfArpSpaCaseBuilder base) {
            this._ofArpSpa = base.isOfArpSpa();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<SrcOfArpSpaCase> getImplementedInterface() {
            return SrcOfArpSpaCase.class;
        }
    
        @Override
        public Boolean isOfArpSpa() {
            return _ofArpSpa;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<SrcOfArpSpaCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ofArpSpa);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcOfArpSpaCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcOfArpSpaCase other = (SrcOfArpSpaCase)obj;
            if (!Objects.equals(_ofArpSpa, other.isOfArpSpa())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcOfArpSpaCaseImpl otherImpl = (SrcOfArpSpaCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcOfArpSpaCase>>, Augmentation<SrcOfArpSpaCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcOfArpSpaCase");
            CodeHelpers.appendValue(helper, "_ofArpSpa", _ofArpSpa);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
