package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.remove.flow.input.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.fin.timeout.grouping.NxActionFinTimeout;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionFinTimeoutRpcRemoveFlowApplyActionsCaseBuilder} instances.
 *
 * @see NxActionFinTimeoutRpcRemoveFlowApplyActionsCaseBuilder
 *
 */
public class NxActionFinTimeoutRpcRemoveFlowApplyActionsCaseBuilder implements Builder<NxActionFinTimeoutRpcRemoveFlowApplyActionsCase> {

    private NxActionFinTimeout _nxActionFinTimeout;


    Map<Class<? extends Augmentation<NxActionFinTimeoutRpcRemoveFlowApplyActionsCase>>, Augmentation<NxActionFinTimeoutRpcRemoveFlowApplyActionsCase>> augmentation = Collections.emptyMap();

    public NxActionFinTimeoutRpcRemoveFlowApplyActionsCaseBuilder() {
    }
    public NxActionFinTimeoutRpcRemoveFlowApplyActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping arg) {
        this._nxActionFinTimeout = arg.getNxActionFinTimeout();
    }

    public NxActionFinTimeoutRpcRemoveFlowApplyActionsCaseBuilder(NxActionFinTimeoutRpcRemoveFlowApplyActionsCase base) {
        this._nxActionFinTimeout = base.getNxActionFinTimeout();
        if (base instanceof NxActionFinTimeoutRpcRemoveFlowApplyActionsCaseImpl) {
            NxActionFinTimeoutRpcRemoveFlowApplyActionsCaseImpl impl = (NxActionFinTimeoutRpcRemoveFlowApplyActionsCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionFinTimeoutRpcRemoveFlowApplyActionsCase>>, Augmentation<NxActionFinTimeoutRpcRemoveFlowApplyActionsCase>> aug =((AugmentationHolder<NxActionFinTimeoutRpcRemoveFlowApplyActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping) {
            this._nxActionFinTimeout = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping)arg).getNxActionFinTimeout();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping]");
    }

    public NxActionFinTimeout getNxActionFinTimeout() {
        return _nxActionFinTimeout;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxActionFinTimeoutRpcRemoveFlowApplyActionsCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionFinTimeoutRpcRemoveFlowApplyActionsCaseBuilder setNxActionFinTimeout(final NxActionFinTimeout value) {
        this._nxActionFinTimeout = value;
        return this;
    }
    
    public NxActionFinTimeoutRpcRemoveFlowApplyActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionFinTimeoutRpcRemoveFlowApplyActionsCase>> augmentationType, Augmentation<NxActionFinTimeoutRpcRemoveFlowApplyActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionFinTimeoutRpcRemoveFlowApplyActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionFinTimeoutRpcRemoveFlowApplyActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionFinTimeoutRpcRemoveFlowApplyActionsCase build() {
        return new NxActionFinTimeoutRpcRemoveFlowApplyActionsCaseImpl(this);
    }

    private static final class NxActionFinTimeoutRpcRemoveFlowApplyActionsCaseImpl implements NxActionFinTimeoutRpcRemoveFlowApplyActionsCase {
    
        private final NxActionFinTimeout _nxActionFinTimeout;
    
        private Map<Class<? extends Augmentation<NxActionFinTimeoutRpcRemoveFlowApplyActionsCase>>, Augmentation<NxActionFinTimeoutRpcRemoveFlowApplyActionsCase>> augmentation = Collections.emptyMap();
    
        NxActionFinTimeoutRpcRemoveFlowApplyActionsCaseImpl(NxActionFinTimeoutRpcRemoveFlowApplyActionsCaseBuilder base) {
            this._nxActionFinTimeout = base.getNxActionFinTimeout();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionFinTimeoutRpcRemoveFlowApplyActionsCase> getImplementedInterface() {
            return NxActionFinTimeoutRpcRemoveFlowApplyActionsCase.class;
        }
    
        @Override
        public NxActionFinTimeout getNxActionFinTimeout() {
            return _nxActionFinTimeout;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxActionFinTimeoutRpcRemoveFlowApplyActionsCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxActionFinTimeout);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionFinTimeoutRpcRemoveFlowApplyActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionFinTimeoutRpcRemoveFlowApplyActionsCase other = (NxActionFinTimeoutRpcRemoveFlowApplyActionsCase)obj;
            if (!Objects.equals(_nxActionFinTimeout, other.getNxActionFinTimeout())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionFinTimeoutRpcRemoveFlowApplyActionsCaseImpl otherImpl = (NxActionFinTimeoutRpcRemoveFlowApplyActionsCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionFinTimeoutRpcRemoveFlowApplyActionsCase>>, Augmentation<NxActionFinTimeoutRpcRemoveFlowApplyActionsCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionFinTimeoutRpcRemoveFlowApplyActionsCase");
            CodeHelpers.appendValue(helper, "_nxActionFinTimeout", _nxActionFinTimeout);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
