package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxResubmitBuilder} instances.
 *
 * @see NxResubmitBuilder
 *
 */
public class NxResubmitBuilder implements Builder<NxResubmit> {

    private Integer _inPort;
    private Short _table;


    Map<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>> augmentation = Collections.emptyMap();

    public NxResubmitBuilder() {
    }

    public NxResubmitBuilder(NxResubmit base) {
        this._inPort = base.getInPort();
        this._table = base.getTable();
        if (base instanceof NxResubmitImpl) {
            NxResubmitImpl impl = (NxResubmitImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>> aug =((AugmentationHolder<NxResubmit>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public Integer getInPort() {
        return _inPort;
    }
    
    public Short getTable() {
        return _table;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxResubmit>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkInPortRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", value);
    }
    
    public NxResubmitBuilder setInPort(final Integer value) {
    if (value != null) {
        checkInPortRange(value);
        
    }
        this._inPort = value;
        return this;
    }
    private static void checkTableRange(final short value) {
        if (value >= (short)0 && value <= (short)255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", value);
    }
    
    public NxResubmitBuilder setTable(final Short value) {
    if (value != null) {
        checkTableRange(value);
        
    }
        this._table = value;
        return this;
    }
    
    public NxResubmitBuilder addAugmentation(Class<? extends Augmentation<NxResubmit>> augmentationType, Augmentation<NxResubmit> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxResubmitBuilder removeAugmentation(Class<? extends Augmentation<NxResubmit>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxResubmit build() {
        return new NxResubmitImpl(this);
    }

    private static final class NxResubmitImpl implements NxResubmit {
    
        private final Integer _inPort;
        private final Short _table;
    
        private Map<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>> augmentation = Collections.emptyMap();
    
        NxResubmitImpl(NxResubmitBuilder base) {
            this._inPort = base.getInPort();
            this._table = base.getTable();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxResubmit> getImplementedInterface() {
            return NxResubmit.class;
        }
    
        @Override
        public Integer getInPort() {
            return _inPort;
        }
        
        @Override
        public Short getTable() {
            return _table;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxResubmit>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_inPort);
            result = prime * result + Objects.hashCode(_table);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxResubmit.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxResubmit other = (NxResubmit)obj;
            if (!Objects.equals(_inPort, other.getInPort())) {
                return false;
            }
            if (!Objects.equals(_table, other.getTable())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxResubmitImpl otherImpl = (NxResubmitImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxResubmit");
            CodeHelpers.appendValue(helper, "_inPort", _inPort);
            CodeHelpers.appendValue(helper, "_table", _table);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
