/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping.NxResubmit;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxResubmitBuilder
implements Builder<NxResubmit> {
    private Integer _inPort;
    private Short _table;
    Map<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>> augmentation = Collections.emptyMap();

    public NxResubmitBuilder() {
    }

    public NxResubmitBuilder(NxResubmit base) {
        Map aug;
        this._inPort = base.getInPort();
        this._table = base.getTable();
        if (base instanceof NxResubmitImpl) {
            NxResubmitImpl impl = (NxResubmitImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>>(aug);
        }
    }

    public Integer getInPort() {
        return this._inPort;
    }

    public Short getTable() {
        return this._table;
    }

    public <E$$ extends Augmentation<NxResubmit>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkInPortRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (Object)value);
    }

    public NxResubmitBuilder setInPort(Integer value) {
        if (value != null) {
            NxResubmitBuilder.checkInPortRange(value);
        }
        this._inPort = value;
        return this;
    }

    private static void checkTableRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..255]]", (Object)value);
    }

    public NxResubmitBuilder setTable(Short value) {
        if (value != null) {
            NxResubmitBuilder.checkTableRange(value);
        }
        this._table = value;
        return this;
    }

    public NxResubmitBuilder addAugmentation(Class<? extends Augmentation<NxResubmit>> augmentationType, Augmentation<NxResubmit> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NxResubmitBuilder removeAugmentation(Class<? extends Augmentation<NxResubmit>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxResubmit build() {
        return new NxResubmitImpl(this);
    }

    private static final class NxResubmitImpl
    implements NxResubmit {
        private final Integer _inPort;
        private final Short _table;
        private Map<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NxResubmitImpl(NxResubmitBuilder base) {
            this._inPort = base.getInPort();
            this._table = base.getTable();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<NxResubmit> getImplementedInterface() {
            return NxResubmit.class;
        }

        @Override
        public Integer getInPort() {
            return this._inPort;
        }

        @Override
        public Short getTable() {
            return this._table;
        }

        public <E$$ extends Augmentation<NxResubmit>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._inPort);
            result = 31 * result + Objects.hashCode(this._table);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxResubmit.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxResubmit other = (NxResubmit)obj;
            if (!Objects.equals(this._inPort, other.getInPort())) {
                return false;
            }
            if (!Objects.equals(this._table, other.getTable())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxResubmitImpl otherImpl = (NxResubmitImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NxResubmit");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_inPort", (Object)this._inPort);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_table", (Object)this._table);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

