/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.move.grouping.nx.reg.move;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.SrcChoiceGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.move.grouping.nx.reg.move.Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.SrcChoice;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SrcBuilder
implements Builder<Src> {
    private Integer _end;
    private SrcChoice _srcChoice;
    private Integer _start;
    Map<Class<? extends Augmentation<Src>>, Augmentation<Src>> augmentation = Collections.emptyMap();

    public SrcBuilder() {
    }

    public SrcBuilder(SrcChoiceGrouping arg) {
        this._srcChoice = arg.getSrcChoice();
    }

    public SrcBuilder(RangeGrouping arg) {
        this._start = arg.getStart();
        this._end = arg.getEnd();
    }

    public SrcBuilder(Src base) {
        Map aug;
        this._end = base.getEnd();
        this._srcChoice = base.getSrcChoice();
        this._start = base.getStart();
        if (base instanceof SrcImpl) {
            SrcImpl impl = (SrcImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Src>>, Augmentation<Src>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Src>>, Augmentation<Src>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SrcChoiceGrouping) {
            this._srcChoice = ((SrcChoiceGrouping)arg).getSrcChoice();
            isValidArg = true;
        }
        if (arg instanceof RangeGrouping) {
            this._start = ((RangeGrouping)arg).getStart();
            this._end = ((RangeGrouping)arg).getEnd();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.SrcChoiceGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping]");
    }

    public Integer getEnd() {
        return this._end;
    }

    public SrcChoice getSrcChoice() {
        return this._srcChoice;
    }

    public Integer getStart() {
        return this._start;
    }

    public <E$$ extends Augmentation<Src>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkEndRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (Object)value);
    }

    public SrcBuilder setEnd(Integer value) {
        if (value != null) {
            SrcBuilder.checkEndRange(value);
        }
        this._end = value;
        return this;
    }

    public SrcBuilder setSrcChoice(SrcChoice value) {
        this._srcChoice = value;
        return this;
    }

    private static void checkStartRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (Object)value);
    }

    public SrcBuilder setStart(Integer value) {
        if (value != null) {
            SrcBuilder.checkStartRange(value);
        }
        this._start = value;
        return this;
    }

    public SrcBuilder addAugmentation(Class<? extends Augmentation<Src>> augmentationType, Augmentation<Src> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Src>>, Augmentation<Src>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SrcBuilder removeAugmentation(Class<? extends Augmentation<Src>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Src build() {
        return new SrcImpl(this);
    }

    private static final class SrcImpl
    implements Src {
        private final Integer _end;
        private final SrcChoice _srcChoice;
        private final Integer _start;
        private Map<Class<? extends Augmentation<Src>>, Augmentation<Src>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        SrcImpl(SrcBuilder base) {
            this._end = base.getEnd();
            this._srcChoice = base.getSrcChoice();
            this._start = base.getStart();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Src> getImplementedInterface() {
            return Src.class;
        }

        @Override
        public Integer getEnd() {
            return this._end;
        }

        @Override
        public SrcChoice getSrcChoice() {
            return this._srcChoice;
        }

        @Override
        public Integer getStart() {
            return this._start;
        }

        public <E$$ extends Augmentation<Src>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._end);
            result = 31 * result + Objects.hashCode(this._srcChoice);
            result = 31 * result + Objects.hashCode(this._start);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Src.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Src other = (Src)obj;
            if (!Objects.equals(this._end, other.getEnd())) {
                return false;
            }
            if (!Objects.equals(this._srcChoice, other.getSrcChoice())) {
                return false;
            }
            if (!Objects.equals(this._start, other.getStart())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SrcImpl otherImpl = (SrcImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Src>>, Augmentation<Src>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Src");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_end", (Object)this._end);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_srcChoice", (Object)this._srcChoice);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_start", (Object)this._start);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

