package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.group.input.original.group.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.fin.timeout.grouping.NxActionFinTimeout;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionFinTimeoutRpcUpdateGroupOriginalCaseBuilder} instances.
 *
 * @see NxActionFinTimeoutRpcUpdateGroupOriginalCaseBuilder
 *
 */
public class NxActionFinTimeoutRpcUpdateGroupOriginalCaseBuilder implements Builder<NxActionFinTimeoutRpcUpdateGroupOriginalCase> {

    private NxActionFinTimeout _nxActionFinTimeout;


    Map<Class<? extends Augmentation<NxActionFinTimeoutRpcUpdateGroupOriginalCase>>, Augmentation<NxActionFinTimeoutRpcUpdateGroupOriginalCase>> augmentation = Collections.emptyMap();

    public NxActionFinTimeoutRpcUpdateGroupOriginalCaseBuilder() {
    }
    public NxActionFinTimeoutRpcUpdateGroupOriginalCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping arg) {
        this._nxActionFinTimeout = arg.getNxActionFinTimeout();
    }

    public NxActionFinTimeoutRpcUpdateGroupOriginalCaseBuilder(NxActionFinTimeoutRpcUpdateGroupOriginalCase base) {
        this._nxActionFinTimeout = base.getNxActionFinTimeout();
        if (base instanceof NxActionFinTimeoutRpcUpdateGroupOriginalCaseImpl) {
            NxActionFinTimeoutRpcUpdateGroupOriginalCaseImpl impl = (NxActionFinTimeoutRpcUpdateGroupOriginalCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionFinTimeoutRpcUpdateGroupOriginalCase>>, Augmentation<NxActionFinTimeoutRpcUpdateGroupOriginalCase>> aug =((AugmentationHolder<NxActionFinTimeoutRpcUpdateGroupOriginalCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping) {
            this._nxActionFinTimeout = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping)arg).getNxActionFinTimeout();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping]");
    }

    public NxActionFinTimeout getNxActionFinTimeout() {
        return _nxActionFinTimeout;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionFinTimeoutRpcUpdateGroupOriginalCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionFinTimeoutRpcUpdateGroupOriginalCaseBuilder setNxActionFinTimeout(final NxActionFinTimeout value) {
        this._nxActionFinTimeout = value;
        return this;
    }
    
    public NxActionFinTimeoutRpcUpdateGroupOriginalCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionFinTimeoutRpcUpdateGroupOriginalCase>> augmentationType, Augmentation<NxActionFinTimeoutRpcUpdateGroupOriginalCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionFinTimeoutRpcUpdateGroupOriginalCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionFinTimeoutRpcUpdateGroupOriginalCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionFinTimeoutRpcUpdateGroupOriginalCase build() {
        return new NxActionFinTimeoutRpcUpdateGroupOriginalCaseImpl(this);
    }

    private static final class NxActionFinTimeoutRpcUpdateGroupOriginalCaseImpl implements NxActionFinTimeoutRpcUpdateGroupOriginalCase {
    
        private final NxActionFinTimeout _nxActionFinTimeout;
    
        private Map<Class<? extends Augmentation<NxActionFinTimeoutRpcUpdateGroupOriginalCase>>, Augmentation<NxActionFinTimeoutRpcUpdateGroupOriginalCase>> augmentation = Collections.emptyMap();
    
        NxActionFinTimeoutRpcUpdateGroupOriginalCaseImpl(NxActionFinTimeoutRpcUpdateGroupOriginalCaseBuilder base) {
            this._nxActionFinTimeout = base.getNxActionFinTimeout();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionFinTimeoutRpcUpdateGroupOriginalCase> getImplementedInterface() {
            return NxActionFinTimeoutRpcUpdateGroupOriginalCase.class;
        }
    
        @Override
        public NxActionFinTimeout getNxActionFinTimeout() {
            return _nxActionFinTimeout;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<NxActionFinTimeoutRpcUpdateGroupOriginalCase>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxActionFinTimeout);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionFinTimeoutRpcUpdateGroupOriginalCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionFinTimeoutRpcUpdateGroupOriginalCase other = (NxActionFinTimeoutRpcUpdateGroupOriginalCase)obj;
            if (!Objects.equals(_nxActionFinTimeout, other.getNxActionFinTimeout())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionFinTimeoutRpcUpdateGroupOriginalCaseImpl otherImpl = (NxActionFinTimeoutRpcUpdateGroupOriginalCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionFinTimeoutRpcUpdateGroupOriginalCase>>, Augmentation<NxActionFinTimeoutRpcUpdateGroupOriginalCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionFinTimeoutRpcUpdateGroupOriginalCase");
            CodeHelpers.appendValue(helper, "_nxActionFinTimeout", _nxActionFinTimeout);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
