package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.flow.input.original.flow.instructions.instruction.instruction.write.actions._case.write.actions.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.move.grouping.NxRegMove;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCaseBuilder} instances.
 *
 * @see NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCaseBuilder
 *
 */
public class NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCaseBuilder implements Builder<NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase> {

    private NxRegMove _nxRegMove;


    Map<Class<? extends Augmentation<NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase>>, Augmentation<NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase>> augmentation = Collections.emptyMap();

    public NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCaseBuilder() {
    }
    public NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping arg) {
        this._nxRegMove = arg.getNxRegMove();
    }

    public NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCaseBuilder(NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase base) {
        this._nxRegMove = base.getNxRegMove();
        if (base instanceof NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCaseImpl) {
            NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCaseImpl impl = (NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase>>, Augmentation<NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase>> aug =((AugmentationHolder<NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping) {
            this._nxRegMove = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping)arg).getNxRegMove();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping]");
    }

    public NxRegMove getNxRegMove() {
        return _nxRegMove;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCaseBuilder setNxRegMove(final NxRegMove value) {
        this._nxRegMove = value;
        return this;
    }
    
    public NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase>> augmentationType, Augmentation<NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase build() {
        return new NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCaseImpl(this);
    }

    private static final class NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCaseImpl implements NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase {
    
        private final NxRegMove _nxRegMove;
    
        private Map<Class<? extends Augmentation<NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase>>, Augmentation<NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase>> augmentation = Collections.emptyMap();
    
        NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCaseImpl(NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCaseBuilder base) {
            this._nxRegMove = base.getNxRegMove();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase> getImplementedInterface() {
            return NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase.class;
        }
    
        @Override
        public NxRegMove getNxRegMove() {
            return _nxRegMove;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxRegMove);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase other = (NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase)obj;
            if (!Objects.equals(_nxRegMove, other.getNxRegMove())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCaseImpl otherImpl = (NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase>>, Augmentation<NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionRegMoveRpcUpdateFlowOriginalWriteActionsCase");
            CodeHelpers.appendValue(helper, "_nxRegMove", _nxRegMove);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
