package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.remove.flow.input.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.ct.clear.grouping.NxCtClear;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionCtClearRpcRemoveFlowApplyActionsCaseBuilder} instances.
 *
 * @see NxActionCtClearRpcRemoveFlowApplyActionsCaseBuilder
 *
 */
public class NxActionCtClearRpcRemoveFlowApplyActionsCaseBuilder implements Builder<NxActionCtClearRpcRemoveFlowApplyActionsCase> {

    private NxCtClear _nxCtClear;


    Map<Class<? extends Augmentation<NxActionCtClearRpcRemoveFlowApplyActionsCase>>, Augmentation<NxActionCtClearRpcRemoveFlowApplyActionsCase>> augmentation = Collections.emptyMap();

    public NxActionCtClearRpcRemoveFlowApplyActionsCaseBuilder() {
    }
    public NxActionCtClearRpcRemoveFlowApplyActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping arg) {
        this._nxCtClear = arg.getNxCtClear();
    }

    public NxActionCtClearRpcRemoveFlowApplyActionsCaseBuilder(NxActionCtClearRpcRemoveFlowApplyActionsCase base) {
        this._nxCtClear = base.getNxCtClear();
        if (base instanceof NxActionCtClearRpcRemoveFlowApplyActionsCaseImpl) {
            NxActionCtClearRpcRemoveFlowApplyActionsCaseImpl impl = (NxActionCtClearRpcRemoveFlowApplyActionsCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionCtClearRpcRemoveFlowApplyActionsCase>>, Augmentation<NxActionCtClearRpcRemoveFlowApplyActionsCase>> aug =((AugmentationHolder<NxActionCtClearRpcRemoveFlowApplyActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping) {
            this._nxCtClear = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping)arg).getNxCtClear();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping]");
    }

    public NxCtClear getNxCtClear() {
        return _nxCtClear;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionCtClearRpcRemoveFlowApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionCtClearRpcRemoveFlowApplyActionsCaseBuilder setNxCtClear(final NxCtClear value) {
        this._nxCtClear = value;
        return this;
    }
    
    public NxActionCtClearRpcRemoveFlowApplyActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionCtClearRpcRemoveFlowApplyActionsCase>> augmentationType, Augmentation<NxActionCtClearRpcRemoveFlowApplyActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionCtClearRpcRemoveFlowApplyActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionCtClearRpcRemoveFlowApplyActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionCtClearRpcRemoveFlowApplyActionsCase build() {
        return new NxActionCtClearRpcRemoveFlowApplyActionsCaseImpl(this);
    }

    private static final class NxActionCtClearRpcRemoveFlowApplyActionsCaseImpl implements NxActionCtClearRpcRemoveFlowApplyActionsCase {
    
        private final NxCtClear _nxCtClear;
    
        private Map<Class<? extends Augmentation<NxActionCtClearRpcRemoveFlowApplyActionsCase>>, Augmentation<NxActionCtClearRpcRemoveFlowApplyActionsCase>> augmentation = Collections.emptyMap();
    
        NxActionCtClearRpcRemoveFlowApplyActionsCaseImpl(NxActionCtClearRpcRemoveFlowApplyActionsCaseBuilder base) {
            this._nxCtClear = base.getNxCtClear();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionCtClearRpcRemoveFlowApplyActionsCase> getImplementedInterface() {
            return NxActionCtClearRpcRemoveFlowApplyActionsCase.class;
        }
    
        @Override
        public NxCtClear getNxCtClear() {
            return _nxCtClear;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<NxActionCtClearRpcRemoveFlowApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxCtClear);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionCtClearRpcRemoveFlowApplyActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionCtClearRpcRemoveFlowApplyActionsCase other = (NxActionCtClearRpcRemoveFlowApplyActionsCase)obj;
            if (!Objects.equals(_nxCtClear, other.getNxCtClear())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionCtClearRpcRemoveFlowApplyActionsCaseImpl otherImpl = (NxActionCtClearRpcRemoveFlowApplyActionsCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionCtClearRpcRemoveFlowApplyActionsCase>>, Augmentation<NxActionCtClearRpcRemoveFlowApplyActionsCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionCtClearRpcRemoveFlowApplyActionsCase");
            CodeHelpers.appendValue(helper, "_nxCtClear", _nxCtClear);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
