package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nodes.node.table.flow.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.NxOutputReg;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionOutputRegNodesNodeTableFlowApplyActionsCaseBuilder} instances.
 *
 * @see NxActionOutputRegNodesNodeTableFlowApplyActionsCaseBuilder
 *
 */
public class NxActionOutputRegNodesNodeTableFlowApplyActionsCaseBuilder implements Builder<NxActionOutputRegNodesNodeTableFlowApplyActionsCase> {

    private NxOutputReg _nxOutputReg;


    Map<Class<? extends Augmentation<NxActionOutputRegNodesNodeTableFlowApplyActionsCase>>, Augmentation<NxActionOutputRegNodesNodeTableFlowApplyActionsCase>> augmentation = Collections.emptyMap();

    public NxActionOutputRegNodesNodeTableFlowApplyActionsCaseBuilder() {
    }
    public NxActionOutputRegNodesNodeTableFlowApplyActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping arg) {
        this._nxOutputReg = arg.getNxOutputReg();
    }

    public NxActionOutputRegNodesNodeTableFlowApplyActionsCaseBuilder(NxActionOutputRegNodesNodeTableFlowApplyActionsCase base) {
        this._nxOutputReg = base.getNxOutputReg();
        if (base instanceof NxActionOutputRegNodesNodeTableFlowApplyActionsCaseImpl) {
            NxActionOutputRegNodesNodeTableFlowApplyActionsCaseImpl impl = (NxActionOutputRegNodesNodeTableFlowApplyActionsCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionOutputRegNodesNodeTableFlowApplyActionsCase>>, Augmentation<NxActionOutputRegNodesNodeTableFlowApplyActionsCase>> aug =((AugmentationHolder<NxActionOutputRegNodesNodeTableFlowApplyActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping) {
            this._nxOutputReg = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping)arg).getNxOutputReg();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping]");
    }

    public NxOutputReg getNxOutputReg() {
        return _nxOutputReg;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionOutputRegNodesNodeTableFlowApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionOutputRegNodesNodeTableFlowApplyActionsCaseBuilder setNxOutputReg(final NxOutputReg value) {
        this._nxOutputReg = value;
        return this;
    }
    
    public NxActionOutputRegNodesNodeTableFlowApplyActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionOutputRegNodesNodeTableFlowApplyActionsCase>> augmentationType, Augmentation<NxActionOutputRegNodesNodeTableFlowApplyActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionOutputRegNodesNodeTableFlowApplyActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionOutputRegNodesNodeTableFlowApplyActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionOutputRegNodesNodeTableFlowApplyActionsCase build() {
        return new NxActionOutputRegNodesNodeTableFlowApplyActionsCaseImpl(this);
    }

    private static final class NxActionOutputRegNodesNodeTableFlowApplyActionsCaseImpl implements NxActionOutputRegNodesNodeTableFlowApplyActionsCase {
    
        private final NxOutputReg _nxOutputReg;
    
        private Map<Class<? extends Augmentation<NxActionOutputRegNodesNodeTableFlowApplyActionsCase>>, Augmentation<NxActionOutputRegNodesNodeTableFlowApplyActionsCase>> augmentation = Collections.emptyMap();
    
        NxActionOutputRegNodesNodeTableFlowApplyActionsCaseImpl(NxActionOutputRegNodesNodeTableFlowApplyActionsCaseBuilder base) {
            this._nxOutputReg = base.getNxOutputReg();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionOutputRegNodesNodeTableFlowApplyActionsCase> getImplementedInterface() {
            return NxActionOutputRegNodesNodeTableFlowApplyActionsCase.class;
        }
    
        @Override
        public NxOutputReg getNxOutputReg() {
            return _nxOutputReg;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<NxActionOutputRegNodesNodeTableFlowApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxOutputReg);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionOutputRegNodesNodeTableFlowApplyActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionOutputRegNodesNodeTableFlowApplyActionsCase other = (NxActionOutputRegNodesNodeTableFlowApplyActionsCase)obj;
            if (!Objects.equals(_nxOutputReg, other.getNxOutputReg())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionOutputRegNodesNodeTableFlowApplyActionsCaseImpl otherImpl = (NxActionOutputRegNodesNodeTableFlowApplyActionsCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionOutputRegNodesNodeTableFlowApplyActionsCase>>, Augmentation<NxActionOutputRegNodesNodeTableFlowApplyActionsCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionOutputRegNodesNodeTableFlowApplyActionsCase");
            CodeHelpers.appendValue(helper, "_nxOutputReg", _nxOutputReg);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
