package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.get.flow.statistics.output.flow.and.statistics.map.list.instructions.instruction.instruction.write.actions._case.write.actions.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.NxLearn;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionLearnNotifDirectStatisticsUpdateWriteActionsCaseBuilder} instances.
 *
 * @see NxActionLearnNotifDirectStatisticsUpdateWriteActionsCaseBuilder
 *
 */
public class NxActionLearnNotifDirectStatisticsUpdateWriteActionsCaseBuilder implements Builder<NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase> {

    private NxLearn _nxLearn;


    Map<Class<? extends Augmentation<NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase>>, Augmentation<NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase>> augmentation = Collections.emptyMap();

    public NxActionLearnNotifDirectStatisticsUpdateWriteActionsCaseBuilder() {
    }
    public NxActionLearnNotifDirectStatisticsUpdateWriteActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping arg) {
        this._nxLearn = arg.getNxLearn();
    }

    public NxActionLearnNotifDirectStatisticsUpdateWriteActionsCaseBuilder(NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase base) {
        this._nxLearn = base.getNxLearn();
        if (base instanceof NxActionLearnNotifDirectStatisticsUpdateWriteActionsCaseImpl) {
            NxActionLearnNotifDirectStatisticsUpdateWriteActionsCaseImpl impl = (NxActionLearnNotifDirectStatisticsUpdateWriteActionsCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase>>, Augmentation<NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase>> aug =((AugmentationHolder<NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping) {
            this._nxLearn = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping)arg).getNxLearn();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping]");
    }

    public NxLearn getNxLearn() {
        return _nxLearn;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionLearnNotifDirectStatisticsUpdateWriteActionsCaseBuilder setNxLearn(final NxLearn value) {
        this._nxLearn = value;
        return this;
    }
    
    public NxActionLearnNotifDirectStatisticsUpdateWriteActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase>> augmentationType, Augmentation<NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionLearnNotifDirectStatisticsUpdateWriteActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase build() {
        return new NxActionLearnNotifDirectStatisticsUpdateWriteActionsCaseImpl(this);
    }

    private static final class NxActionLearnNotifDirectStatisticsUpdateWriteActionsCaseImpl implements NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase {
    
        private final NxLearn _nxLearn;
    
        private Map<Class<? extends Augmentation<NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase>>, Augmentation<NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase>> augmentation = Collections.emptyMap();
    
        NxActionLearnNotifDirectStatisticsUpdateWriteActionsCaseImpl(NxActionLearnNotifDirectStatisticsUpdateWriteActionsCaseBuilder base) {
            this._nxLearn = base.getNxLearn();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase> getImplementedInterface() {
            return NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase.class;
        }
    
        @Override
        public NxLearn getNxLearn() {
            return _nxLearn;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxLearn);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase other = (NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase)obj;
            if (!Objects.equals(_nxLearn, other.getNxLearn())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionLearnNotifDirectStatisticsUpdateWriteActionsCaseImpl otherImpl = (NxActionLearnNotifDirectStatisticsUpdateWriteActionsCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase>>, Augmentation<NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionLearnNotifDirectStatisticsUpdateWriteActionsCase");
            CodeHelpers.appendValue(helper, "_nxLearn", _nxLearn);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
