package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.get.flow.statistics.output.flow.and.statistics.map.list.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseBuilder} instances.
 *
 * @see NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseBuilder
 *
 */
public class NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseBuilder implements Builder<NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase> {

    private NxConntrack _nxConntrack;


    Map<Class<? extends Augmentation<NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase>> augmentation = Collections.emptyMap();

    public NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseBuilder() {
    }
    public NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping arg) {
        this._nxConntrack = arg.getNxConntrack();
    }

    public NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseBuilder(NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase base) {
        this._nxConntrack = base.getNxConntrack();
        if (base instanceof NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseImpl) {
            NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseImpl impl = (NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase>> aug =((AugmentationHolder<NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping) {
            this._nxConntrack = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping)arg).getNxConntrack();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping]");
    }

    public NxConntrack getNxConntrack() {
        return _nxConntrack;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseBuilder setNxConntrack(final NxConntrack value) {
        this._nxConntrack = value;
        return this;
    }
    
    public NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase>> augmentationType, Augmentation<NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase build() {
        return new NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseImpl(this);
    }

    private static final class NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseImpl implements NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase {
    
        private final NxConntrack _nxConntrack;
    
        private Map<Class<? extends Augmentation<NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase>> augmentation = Collections.emptyMap();
    
        NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseImpl(NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseBuilder base) {
            this._nxConntrack = base.getNxConntrack();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase> getImplementedInterface() {
            return NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase.class;
        }
    
        @Override
        public NxConntrack getNxConntrack() {
            return _nxConntrack;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxConntrack);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase other = (NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase)obj;
            if (!Objects.equals(_nxConntrack, other.getNxConntrack())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseImpl otherImpl = (NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase>>, Augmentation<NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionConntrackNotifDirectStatisticsUpdateApplyActionsCase");
            CodeHelpers.appendValue(helper, "_nxConntrack", _nxConntrack);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
