package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flows.statistics.update.flow.and.statistics.map.list.instructions.instruction.instruction.write.actions._case.write.actions.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.decap.grouping.NxDecap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseBuilder} instances.
 *
 * @see NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseBuilder
 *
 */
public class NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseBuilder implements Builder<NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase> {

    private NxDecap _nxDecap;


    Map<Class<? extends Augmentation<NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase>>, Augmentation<NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase>> augmentation = Collections.emptyMap();

    public NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseBuilder() {
    }
    public NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping arg) {
        this._nxDecap = arg.getNxDecap();
    }

    public NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseBuilder(NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase base) {
        this._nxDecap = base.getNxDecap();
        if (base instanceof NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseImpl) {
            NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseImpl impl = (NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase>>, Augmentation<NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase>> aug =((AugmentationHolder<NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping) {
            this._nxDecap = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping)arg).getNxDecap();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionDecapGrouping]");
    }

    public NxDecap getNxDecap() {
        return _nxDecap;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseBuilder setNxDecap(final NxDecap value) {
        this._nxDecap = value;
        return this;
    }
    
    public NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase>> augmentationType, Augmentation<NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase build() {
        return new NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseImpl(this);
    }

    private static final class NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseImpl implements NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase {
    
        private final NxDecap _nxDecap;
    
        private Map<Class<? extends Augmentation<NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase>>, Augmentation<NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase>> augmentation = Collections.emptyMap();
    
        NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseImpl(NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseBuilder base) {
            this._nxDecap = base.getNxDecap();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase> getImplementedInterface() {
            return NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase.class;
        }
    
        @Override
        public NxDecap getNxDecap() {
            return _nxDecap;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxDecap);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase other = (NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase)obj;
            if (!Objects.equals(_nxDecap, other.getNxDecap())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseImpl otherImpl = (NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase>>, Augmentation<NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionDecapNotifFlowsStatisticsUpdateWriteActionsCase");
            CodeHelpers.appendValue(helper, "_nxDecap", _nxDecap);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
