package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DstOfMplsLabelCaseBuilder} instances.
 *
 * @see DstOfMplsLabelCaseBuilder
 *
 */
public class DstOfMplsLabelCaseBuilder implements Builder<DstOfMplsLabelCase> {

    private Boolean _ofMplsLabel;


    Map<Class<? extends Augmentation<DstOfMplsLabelCase>>, Augmentation<DstOfMplsLabelCase>> augmentation = Collections.emptyMap();

    public DstOfMplsLabelCaseBuilder() {
    }
    public DstOfMplsLabelCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping arg) {
        this._ofMplsLabel = arg.isOfMplsLabel();
    }

    public DstOfMplsLabelCaseBuilder(DstOfMplsLabelCase base) {
        this._ofMplsLabel = base.isOfMplsLabel();
        if (base instanceof DstOfMplsLabelCaseImpl) {
            DstOfMplsLabelCaseImpl impl = (DstOfMplsLabelCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DstOfMplsLabelCase>>, Augmentation<DstOfMplsLabelCase>> aug =((AugmentationHolder<DstOfMplsLabelCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping) {
            this._ofMplsLabel = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping)arg).isOfMplsLabel();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OxmOfMplsLabelGrouping]");
    }

    public Boolean isOfMplsLabel() {
        return _ofMplsLabel;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<DstOfMplsLabelCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstOfMplsLabelCaseBuilder setOfMplsLabel(final Boolean value) {
        this._ofMplsLabel = value;
        return this;
    }
    
    public DstOfMplsLabelCaseBuilder addAugmentation(Class<? extends Augmentation<DstOfMplsLabelCase>> augmentationType, Augmentation<DstOfMplsLabelCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstOfMplsLabelCaseBuilder removeAugmentation(Class<? extends Augmentation<DstOfMplsLabelCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstOfMplsLabelCase build() {
        return new DstOfMplsLabelCaseImpl(this);
    }

    private static final class DstOfMplsLabelCaseImpl implements DstOfMplsLabelCase {
    
        private final Boolean _ofMplsLabel;
    
        private Map<Class<? extends Augmentation<DstOfMplsLabelCase>>, Augmentation<DstOfMplsLabelCase>> augmentation = Collections.emptyMap();
    
        DstOfMplsLabelCaseImpl(DstOfMplsLabelCaseBuilder base) {
            this._ofMplsLabel = base.isOfMplsLabel();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<DstOfMplsLabelCase> getImplementedInterface() {
            return DstOfMplsLabelCase.class;
        }
    
        @Override
        public Boolean isOfMplsLabel() {
            return _ofMplsLabel;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<DstOfMplsLabelCase>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ofMplsLabel);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstOfMplsLabelCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DstOfMplsLabelCase other = (DstOfMplsLabelCase)obj;
            if (!Objects.equals(_ofMplsLabel, other.isOfMplsLabel())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstOfMplsLabelCaseImpl otherImpl = (DstOfMplsLabelCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstOfMplsLabelCase>>, Augmentation<DstOfMplsLabelCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstOfMplsLabelCase");
            CodeHelpers.appendValue(helper, "_ofMplsLabel", _ofMplsLabel);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
